/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import io.prestosql.orc.OrcDataSink;
import io.prestosql.orc.stream.OrcDataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class OutputStreamOrcDataSink
implements OrcDataSink {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OutputStreamOrcDataSink.class).instanceSize();
    private final OutputStreamSliceOutput output;

    public OutputStreamOrcDataSink(OutputStream outputStream) {
        this.output = new OutputStreamSliceOutput(Objects.requireNonNull(outputStream, "outputStream is null"));
    }

    @Override
    public long size() {
        return this.output.longSize();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.output.getRetainedSize();
    }

    @Override
    public void write(List<OrcDataOutput> outputData) {
        outputData.forEach(data -> data.writeData((SliceOutput)this.output));
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

