/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.orc.RowGroup;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.stream.InputStreamSources;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Stripe {
    private final long rowCount;
    private final ZoneId timeZone;
    private final List<ColumnEncoding> columnEncodings;
    private final List<RowGroup> rowGroups;
    private final InputStreamSources dictionaryStreamSources;

    public Stripe(long rowCount, ZoneId timeZone, List<ColumnEncoding> columnEncodings, List<RowGroup> rowGroups, InputStreamSources dictionaryStreamSources) {
        this.rowCount = rowCount;
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.columnEncodings = Objects.requireNonNull(columnEncodings, "columnEncodings is null");
        this.rowGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(rowGroups, "rowGroups is null"));
        this.dictionaryStreamSources = Objects.requireNonNull(dictionaryStreamSources, "dictionaryStreamSources is null");
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public List<ColumnEncoding> getColumnEncodings() {
        return this.columnEncodings;
    }

    public List<RowGroup> getRowGroups() {
        return this.rowGroups;
    }

    public InputStreamSources getDictionaryStreamSources() {
        return this.dictionaryStreamSources;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", this.rowCount).add("timeZone", (Object)this.timeZone).add("columnEncodings", this.columnEncodings).add("rowGroups", this.rowGroups).add("dictionaryStreams", (Object)this.dictionaryStreamSources).toString();
    }
}

