/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata.statistics;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.prestosql.orc.metadata.statistics.BinaryStatistics;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BinaryStatisticsBuilder
implements SliceColumnStatisticsBuilder {
    private long nonNullValueCount;
    private long sum;

    @Override
    public void addValue(Slice value) {
        Objects.requireNonNull(value, "value is null");
        this.sum += (long)value.length();
        ++this.nonNullValueCount;
    }

    private Optional<BinaryStatistics> buildBinaryStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new BinaryStatistics(this.sum));
    }

    private void addBinaryStatistics(long valueCount, BinaryStatistics value) {
        Objects.requireNonNull(value, "value is null");
        this.nonNullValueCount += valueCount;
        this.sum += value.getSum();
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<BinaryStatistics> binaryStatistics = this.buildBinaryStatistics();
        binaryStatistics.ifPresent(s -> Verify.verify((this.nonNullValueCount > 0L ? 1 : 0) != 0));
        return new ColumnStatistics(this.nonNullValueCount, binaryStatistics.map(s -> 5L + this.sum / this.nonNullValueCount).orElse(0L), null, null, null, null, null, null, binaryStatistics.orElse(null), null);
    }

    public static Optional<BinaryStatistics> mergeBinaryStatistics(List<ColumnStatistics> stats) {
        BinaryStatisticsBuilder binaryStatisticsBuilder = new BinaryStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            BinaryStatistics partialStatistics = columnStatistics.getBinaryStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            binaryStatisticsBuilder.addBinaryStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return binaryStatisticsBuilder.buildBinaryStatistics();
    }
}

