/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.DecimalInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class DecimalStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private boolean[] nullVector = new boolean[0];
    private long[] scaleVector = new long[0];
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<DecimalInputStream> decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
    @Nullable
    private DecimalInputStream decimalStream;
    private InputStreamSource<LongInputStream> scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream scaleStream;
    private boolean rowGroupOpen;
    private final LocalMemoryContext systemMemoryContext;

    public DecimalStreamReader(StreamDescriptor streamDescriptor, LocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        DecimalType decimalType = (DecimalType)type;
        int targetScale = decimalType.getScale();
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.seekToOffset();
        if (this.decimalStream == null && this.scaleStream == null && this.presentStream != null) {
            this.presentStream.skip(this.nextBatchSize);
            Block nullValueBlock = RunLengthEncodedBlock.create((Type)type, null, (int)this.nextBatchSize);
            this.readOffset = 0;
            this.nextBatchSize = 0;
            return nullValueBlock;
        }
        BlockBuilder builder = decimalType.createBlockBuilder(null, this.nextBatchSize);
        if (this.presentStream == null) {
            if (this.decimalStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but decimal stream is not present");
            }
            if (this.scaleStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but scale stream is not present");
            }
            for (int i = 0; i < this.nextBatchSize; ++i) {
                long sourceScale = this.scaleStream.next();
                if (decimalType.isShort()) {
                    long rescaledDecimal = Decimals.rescale((long)this.decimalStream.nextLong(), (int)((int)sourceScale), (int)decimalType.getScale());
                    decimalType.writeLong(builder, rescaledDecimal);
                    continue;
                }
                Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                this.decimalStream.nextLongDecimal(decimal);
                UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)((int)((long)decimalType.getScale() - sourceScale)), (Slice)rescaledDecimal);
                decimalType.writeSlice(builder, rescaledDecimal);
            }
        } else {
            Verify.verify((this.decimalStream != null ? 1 : 0) != 0);
            Verify.verify((this.scaleStream != null ? 1 : 0) != 0);
            for (int i = 0; i < this.nextBatchSize; ++i) {
                if (this.presentStream.nextBit()) {
                    long sourceScale = this.scaleStream.next();
                    if (decimalType.isShort()) {
                        long rescaledDecimal = Decimals.rescale((long)this.decimalStream.nextLong(), (int)((int)sourceScale), (int)decimalType.getScale());
                        decimalType.writeLong(builder, rescaledDecimal);
                        continue;
                    }
                    Slice decimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                    Slice rescaledDecimal = UnscaledDecimal128Arithmetic.unscaledDecimal();
                    this.decimalStream.nextLongDecimal(decimal);
                    UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)((int)((long)decimalType.getScale() - sourceScale)), (Slice)rescaledDecimal);
                    decimalType.writeSlice(builder, rescaledDecimal);
                    continue;
                }
                builder.appendNull();
            }
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return builder.build();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.decimalStream = this.decimalStreamSource.openStream();
        this.scaleStream = this.scaleStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private void seekToOffset() throws IOException {
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.decimalStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but decimal stream is not present");
                }
                if (this.scaleStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but scale stream is not present");
                }
                this.decimalStream.skip(this.readOffset);
                this.scaleStream.skip(this.readOffset);
            }
        }
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
        this.scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.decimalStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, DecimalInputStream.class);
        this.scaleStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.nullVector = null;
        this.scaleVector = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.nullVector) + SizeOf.sizeOf((long[])this.scaleVector);
    }
}

