/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.FloatInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class FloatStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FloatStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean[] nullVector = new boolean[0];
    private InputStreamSource<FloatInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(FloatInputStream.class);
    @Nullable
    private FloatInputStream dataStream;
    private boolean rowGroupOpen;
    private final LocalMemoryContext systemMemoryContext;

    public FloatStreamReader(StreamDescriptor streamDescriptor, LocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        boolean[] isNull;
        int nullCount;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            this.presentStream.skip(this.nextBatchSize);
            Block nullValueBlock = RunLengthEncodedBlock.create((Type)type, null, (int)this.nextBatchSize);
            this.readOffset = 0;
            this.nextBatchSize = 0;
            return nullValueBlock;
        }
        Block block = this.presentStream == null ? this.dataStream.nextBlock(type, this.nextBatchSize) : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.dataStream.nextBlock(type, this.nextBatchSize) : (nullCount != this.nextBatchSize ? this.dataStream.nextBlock(type, isNull) : RunLengthEncodedBlock.create((Type)type, null, (int)this.nextBatchSize)));
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(FloatInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, FloatInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.nullVector = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.nullVector);
    }
}

