/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongDictionaryStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongDictionaryStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean[] nullVector = new boolean[0];
    private InputStreamSource<LongInputStream> dictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private int dictionarySize;
    private long[] dictionary = new long[0];
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream inDictionaryStream;
    private boolean[] inDictionaryVector = new boolean[0];
    private InputStreamSource<LongInputStream> dataStreamSource;
    @Nullable
    private LongInputStream dataStream;
    private long[] dataVector = new long[0];
    private boolean dictionaryOpen;
    private boolean rowGroupOpen;
    private final LocalMemoryContext systemMemoryContext;

    public LongDictionaryStreamReader(StreamDescriptor streamDescriptor, LocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        BlockBuilder builder = type.createBlockBuilder(null, this.nextBatchSize);
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            if (this.inDictionaryStream == null) {
                for (int i = 0; i < this.nextBatchSize; ++i) {
                    type.writeLong(builder, this.dictionary[(int)this.dataStream.next()]);
                }
            } else {
                for (int i = 0; i < this.nextBatchSize; ++i) {
                    long id = this.dataStream.next();
                    if (this.inDictionaryStream.nextBit()) {
                        type.writeLong(builder, this.dictionary[(int)id]);
                        continue;
                    }
                    type.writeLong(builder, id);
                }
            }
        } else if (this.dataStream == null) {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize);
            if (nullValues != this.nextBatchSize) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            for (int i = 0; i < this.nextBatchSize; ++i) {
                builder.appendNull();
            }
        } else {
            for (int i = 0; i < this.nextBatchSize; ++i) {
                if (!this.presentStream.nextBit()) {
                    builder.appendNull();
                    continue;
                }
                long id = this.dataStream.next();
                if (this.inDictionaryStream == null || this.inDictionaryStream.nextBit()) {
                    type.writeLong(builder, this.dictionary[(int)id]);
                    continue;
                }
                type.writeLong(builder, id);
            }
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return builder.build();
    }

    private void openRowGroup() throws IOException {
        if (!this.dictionaryOpen && this.dictionarySize > 0) {
            LongInputStream dictionaryStream;
            if (this.dictionary.length < this.dictionarySize) {
                this.dictionary = new long[this.dictionarySize];
            }
            if ((dictionaryStream = this.dictionaryDataStreamSource.openStream()) == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but data stream is not present");
            }
            dictionaryStream.nextLongVector(this.dictionarySize, this.dictionary);
        }
        this.dictionaryOpen = true;
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.dictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, LongInputStream.class);
        this.dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.dictionaryOpen = false;
        this.inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.nullVector = null;
        this.dataVector = null;
        this.inDictionaryVector = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.nullVector) + SizeOf.sizeOf((long[])this.dataVector) + SizeOf.sizeOf((boolean[])this.inDictionaryVector);
    }
}

