/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.reader.LongDictionaryStreamReader;
import io.prestosql.orc.reader.LongDirectStreamReader;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class LongStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final LongDirectStreamReader directReader;
    private final LongDictionaryStreamReader dictionaryReader;
    private StreamReader currentReader;

    public LongStreamReader(StreamDescriptor streamDescriptor, AggregatedMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.directReader = new LongDirectStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(LongStreamReader.class.getSimpleName()));
        this.dictionaryReader = new LongDictionaryStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(LongStreamReader.class.getSimpleName()));
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.currentReader.prepareNextRead(batchSize);
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        return this.currentReader.readBlock(type);
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncodingKind();
        if (kind == ColumnEncoding.ColumnEncodingKind.DIRECT || kind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2) {
            this.currentReader = this.directReader;
        } else if (kind == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
        }
        this.currentReader.startStripe(timeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.directReader::close);
            closer.register(this.dictionaryReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.directReader.getRetainedSizeInBytes() + this.dictionaryReader.getRetainedSizeInBytes();
    }
}

