/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.reader.StreamReaders;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class MapStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final StreamReader keyStreamReader;
    private final StreamReader valueStreamReader;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    @Nonnull
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;

    public MapStreamReader(StreamDescriptor streamDescriptor, AggregatedMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.keyStreamReader = StreamReaders.createStreamReader(streamDescriptor.getNestedStreams().get(0), systemMemoryContext);
        this.valueStreamReader = StreamReaders.createStreamReader(streamDescriptor.getNestedStreams().get(1), systemMemoryContext);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        Block values;
        Block keys;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                long entrySkipSize = this.lengthStream.sum(this.readOffset);
                this.keyStreamReader.prepareNextRead(Math.toIntExact(entrySkipSize));
                this.valueStreamReader.prepareNextRead(Math.toIntExact(entrySkipSize));
            }
        }
        int[] offsetVector = new int[this.nextBatchSize + 1];
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            this.lengthStream.nextIntVector(this.nextBatchSize, offsetVector, 0);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.lengthStream.nextIntVector(this.nextBatchSize, offsetVector, 0, nullVector);
            }
        }
        MapType mapType = (MapType)type;
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        int entryCount = 0;
        for (int i = 0; i < offsetVector.length - 1; ++i) {
            entryCount += offsetVector[i];
        }
        if (entryCount > 0) {
            this.keyStreamReader.prepareNextRead(entryCount);
            this.valueStreamReader.prepareNextRead(entryCount);
            keys = this.keyStreamReader.readBlock(keyType);
            values = this.valueStreamReader.readBlock(valueType);
        } else {
            keys = keyType.createBlockBuilder(null, 0).build();
            values = valueType.createBlockBuilder(null, 1).build();
        }
        Block[] keyValueBlock = MapStreamReader.createKeyValueBlock(this.nextBatchSize, keys, values, offsetVector);
        int currentLength = offsetVector[0];
        offsetVector[0] = 0;
        for (int i = 1; i < offsetVector.length; ++i) {
            int lastLength = offsetVector[i];
            offsetVector[i] = offsetVector[i - 1] + currentLength;
            currentLength = lastLength;
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return mapType.createBlockFromKeyValue(Optional.ofNullable(nullVector), offsetVector, keyValueBlock[0], keyValueBlock[1]);
    }

    private static Block[] createKeyValueBlock(int positionCount, Block keys, Block values, int[] lengths) {
        if (!MapStreamReader.hasNull(keys)) {
            return new Block[]{keys, values};
        }
        IntArrayList nonNullPositions = new IntArrayList(keys.getPositionCount());
        int position = 0;
        for (int mapIndex = 0; mapIndex < positionCount; ++mapIndex) {
            int length = lengths[mapIndex];
            for (int entryIndex = 0; entryIndex < length; ++entryIndex) {
                if (keys.isNull(position)) {
                    int n = mapIndex;
                    lengths[n] = lengths[n] - 1;
                } else {
                    nonNullPositions.add(position);
                }
                ++position;
            }
        }
        Block newKeys = keys.copyPositions(nonNullPositions.elements(), 0, nonNullPositions.size());
        Block newValues = values.copyPositions(nonNullPositions.elements(), 0, nonNullPositions.size());
        return new Block[]{newKeys, newValues};
    }

    private static boolean hasNull(Block keys) {
        for (int position = 0; position < keys.getPositionCount(); ++position) {
            if (!keys.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startStripe(timeZone, dictionaryStreamSources, encoding);
        this.valueStreamReader.startStripe(timeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startRowGroup(dataStreamSources);
        this.valueStreamReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.keyStreamReader::close);
            closer.register(this.valueStreamReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyStreamReader.getRetainedSizeInBytes() + this.valueStreamReader.getRetainedSizeInBytes();
    }
}

