/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.SliceStreamReader;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.ByteArrayInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.VariableWidthBlock;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryStreamReader.class).instanceSize();
    private static final byte[] EMPTY_DICTIONARY_DATA = new byte[0];
    private static final int[] EMPTY_DICTIONARY_OFFSETS = new int[2];
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean[] isNullVector = new boolean[0];
    private InputStreamSource<ByteArrayInputStream> stripeDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private boolean stripeDictionaryOpen;
    private int stripeDictionarySize;
    private int[] stripeDictionaryLength = new int[0];
    private byte[] stripeDictionaryData = EMPTY_DICTIONARY_DATA;
    private int[] stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
    private VariableWidthBlock dictionaryBlock = new VariableWidthBlock(1, Slices.wrappedBuffer((byte[])EMPTY_DICTIONARY_DATA), EMPTY_DICTIONARY_OFFSETS, Optional.of(new boolean[]{true}));
    private byte[] currentDictionaryData = EMPTY_DICTIONARY_DATA;
    private InputStreamSource<LongInputStream> stripeDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream inDictionaryStream;
    private boolean[] inDictionaryVector = new boolean[0];
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private final LocalMemoryContext systemMemoryContext;

    public SliceDictionaryStreamReader(StreamDescriptor streamDescriptor, LocalMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        int i;
        if (!this.rowGroupOpen) {
            this.openRowGroup(type);
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                if (this.inDictionaryStream != null) {
                    this.inDictionaryStream.skip(this.readOffset);
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        int[] idsVector = new int[this.nextBatchSize];
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            if (this.inDictionaryStream == null) {
                this.dataStream.nextIntVector(this.nextBatchSize, idsVector, 0);
            } else {
                for (i = 0; i < this.nextBatchSize; ++i) {
                    idsVector[i] = Math.toIntExact(this.dataStream.next());
                    if (this.inDictionaryStream.nextBit()) continue;
                    int n = i;
                    idsVector[n] = idsVector[n] + this.stripeDictionarySize;
                }
            }
        } else if (this.dataStream == null) {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize);
            if (nullValues != this.nextBatchSize) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
        } else {
            for (i = 0; i < this.nextBatchSize; ++i) {
                if (!this.presentStream.nextBit()) {
                    idsVector[i] = this.dictionaryBlock.getPositionCount() - 1;
                    continue;
                }
                idsVector[i] = Math.toIntExact(this.dataStream.next());
                if (this.inDictionaryStream == null || this.inDictionaryStream.nextBit()) continue;
                int n = i;
                idsVector[n] = idsVector[n] + this.stripeDictionarySize;
            }
        }
        DictionaryBlock block = new DictionaryBlock(this.nextBatchSize, (Block)this.dictionaryBlock, idsVector);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void setDictionaryBlockData(byte[] dictionaryData, int[] dictionaryOffsets, int positionCount) {
        Verify.verify((positionCount > 0 ? 1 : 0) != 0);
        if (this.currentDictionaryData != dictionaryData) {
            boolean[] isNullVector = new boolean[positionCount];
            isNullVector[positionCount - 1] = true;
            dictionaryOffsets[positionCount] = dictionaryOffsets[positionCount - 1];
            this.dictionaryBlock = new VariableWidthBlock(positionCount, Slices.wrappedBuffer((byte[])dictionaryData), dictionaryOffsets, Optional.of(isNullVector));
            this.currentDictionaryData = dictionaryData;
        }
    }

    private void openRowGroup(Type type) throws IOException {
        if (!this.stripeDictionaryOpen) {
            if (this.stripeDictionarySize > 0) {
                LongInputStream lengthStream;
                if (this.stripeDictionaryLength.length < this.stripeDictionarySize) {
                    this.stripeDictionaryLength = new int[this.stripeDictionarySize];
                }
                if ((lengthStream = this.stripeDictionaryLengthStreamSource.openStream()) == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but dictionary length stream is not present");
                }
                lengthStream.nextIntVector(this.stripeDictionarySize, this.stripeDictionaryLength, 0);
                long dataLength = 0L;
                for (int i = 0; i < this.stripeDictionarySize; ++i) {
                    dataLength += (long)this.stripeDictionaryLength[i];
                }
                this.stripeDictionaryData = new byte[Math.toIntExact(dataLength)];
                this.stripeDictionaryOffsetVector = new int[this.stripeDictionarySize + 2];
                ByteArrayInputStream dictionaryDataStream = this.stripeDictionaryDataStreamSource.openStream();
                SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, this.stripeDictionarySize, this.stripeDictionaryLength, 0, this.stripeDictionaryData, this.stripeDictionaryOffsetVector, type);
            } else {
                this.stripeDictionaryData = EMPTY_DICTIONARY_DATA;
                this.stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
            }
        }
        this.stripeDictionaryOpen = true;
        this.setDictionaryBlockData(this.stripeDictionaryData, this.stripeDictionaryOffsetVector, this.stripeDictionarySize + 1);
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayInputStream dictionaryDataStream, int dictionarySize, int[] dictionaryLengthVector, int offsetVectorOffset, byte[] data, int[] offsetVector, Type type) throws IOException {
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (offsetVectorOffset == 0) {
            offsetVector[0] = 0;
        }
        for (int i = 0; i < dictionarySize; ++i) {
            int truncatedLength;
            int offsetIndex = offsetVectorOffset + i;
            int offset = offsetVector[offsetIndex];
            int length = dictionaryLengthVector[i];
            int maxCodePointCount = SliceStreamReader.getMaxCodePointCount(type);
            boolean isCharType = Chars.isCharType((Type)type);
            if (length > 0) {
                dictionaryDataStream.next(data, offset, offset + length);
                truncatedLength = SliceStreamReader.computeTruncatedLength(slice, offset, length, maxCodePointCount, isCharType);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            } else {
                truncatedLength = 0;
            }
            offsetVector[offsetIndex + 1] = offsetVector[offsetIndex] + truncatedLength;
        }
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.stripeDictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayInputStream.class);
        this.stripeDictionaryLengthStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.stripeDictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.stripeDictionaryOpen = false;
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.isNullVector = null;
        this.inDictionaryVector = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.isNullVector) + SizeOf.sizeOf((boolean[])this.inDictionaryVector);
    }
}

