/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.SliceStreamReader;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.ByteArrayInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.VariableWidthBlock;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceDirectStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDirectStreamReader.class).instanceSize();
    private static final int ONE_GIGABYTE = Math.toIntExact(new DataSize(1.0, DataSize.Unit.GIGABYTE).toBytes());
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private InputStreamSource<ByteArrayInputStream> dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    @Nullable
    private ByteArrayInputStream dataStream;
    private boolean rowGroupOpen;

    public SliceDirectStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but length stream is not present");
                }
                long dataSkipSize = this.lengthStream.sum(this.readOffset);
                if (dataSkipSize > 0L) {
                    if (this.dataStream == null) {
                        throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                    }
                    this.dataStream.skip(dataSkipSize);
                }
            }
        }
        boolean[] isNullVector = null;
        int[] offsetVector = new int[this.nextBatchSize + 1];
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but length stream is not present");
            }
            this.lengthStream.nextIntVector(this.nextBatchSize, offsetVector, 0);
        } else {
            isNullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, isNullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but length stream is not present");
                }
                if (nullValues == 0) {
                    isNullVector = null;
                    this.lengthStream.nextIntVector(this.nextBatchSize, offsetVector, 0);
                } else {
                    this.lengthStream.nextIntVector(this.nextBatchSize, offsetVector, 0, isNullVector);
                }
            }
        }
        long totalLength = 0L;
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (isNullVector != null && isNullVector[i]) continue;
            totalLength += (long)offsetVector[i];
        }
        int currentBatchSize = this.nextBatchSize;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        if (totalLength == 0L) {
            return new VariableWidthBlock(currentBatchSize, Slices.EMPTY_SLICE, offsetVector, Optional.ofNullable(isNullVector));
        }
        if (totalLength > (long)ONE_GIGABYTE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Values in column \"%s\" are too large to process for Presto. %s column values are larger than 1GB [%s]", this.streamDescriptor.getFieldName(), this.nextBatchSize, this.streamDescriptor.getOrcDataSourceId()));
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
        }
        byte[] data = new byte[Math.toIntExact(totalLength)];
        Slice slice = Slices.wrappedBuffer((byte[])data);
        int currentLength = offsetVector[0];
        offsetVector[0] = 0;
        int maxCodePointCount = SliceStreamReader.getMaxCodePointCount(type);
        boolean isCharType = Chars.isCharType((Type)type);
        for (int i = 1; i <= currentBatchSize; ++i) {
            int nextLength = offsetVector[i];
            if (isNullVector != null && isNullVector[i - 1]) {
                Preconditions.checkState((currentLength == 0 ? 1 : 0) != 0, (Object)"Corruption in slice direct stream: length is non-zero for null entry");
                offsetVector[i] = offsetVector[i - 1];
                currentLength = nextLength;
                continue;
            }
            int offset = offsetVector[i - 1];
            this.dataStream.next(data, offset, offset + currentLength);
            int truncatedLength = SliceStreamReader.computeTruncatedLength(slice, offset, currentLength, maxCodePointCount, isCharType);
            Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            offsetVector[i] = offset + truncatedLength;
            currentLength = nextLength;
        }
        return new VariableWidthBlock(currentBatchSize, slice, offsetVector, Optional.ofNullable(isNullVector));
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataByteSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dataByteSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

