/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.reader.BooleanStreamReader;
import io.prestosql.orc.reader.ByteStreamReader;
import io.prestosql.orc.reader.DecimalStreamReader;
import io.prestosql.orc.reader.DoubleStreamReader;
import io.prestosql.orc.reader.FloatStreamReader;
import io.prestosql.orc.reader.ListStreamReader;
import io.prestosql.orc.reader.LongStreamReader;
import io.prestosql.orc.reader.MapStreamReader;
import io.prestosql.orc.reader.SliceStreamReader;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.reader.StructStreamReader;
import io.prestosql.orc.reader.TimestampStreamReader;

public final class StreamReaders {
    private StreamReaders() {
    }

    public static StreamReader createStreamReader(StreamDescriptor streamDescriptor, AggregatedMemoryContext systemMemoryContext) {
        switch (streamDescriptor.getStreamType()) {
            case BOOLEAN: {
                return new BooleanStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case BYTE: {
                return new ByteStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongStreamReader(streamDescriptor, systemMemoryContext);
            }
            case FLOAT: {
                return new FloatStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                return new DoubleStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceStreamReader(streamDescriptor, systemMemoryContext);
            }
            case TIMESTAMP: {
                return new TimestampStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case LIST: {
                return new ListStreamReader(streamDescriptor, systemMemoryContext);
            }
            case STRUCT: {
                return new StructStreamReader(streamDescriptor, systemMemoryContext);
            }
            case MAP: {
                return new MapStreamReader(streamDescriptor, systemMemoryContext);
            }
            case DECIMAL: {
                return new DecimalStreamReader(streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getStreamType()));
    }
}

