/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.airlift.slice.Slice;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.checkpoint.DecimalStreamCheckpoint;
import io.prestosql.orc.stream.OrcInputStream;
import io.prestosql.orc.stream.ValueInputStream;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;
import java.io.IOException;

public class DecimalInputStream
implements ValueInputStream<DecimalStreamCheckpoint> {
    private final OrcInputStream input;

    public DecimalInputStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<? extends DecimalStreamCheckpoint> getCheckpointType() {
        return DecimalStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(DecimalStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    public void nextLongDecimal(Slice result) throws IOException {
        long b;
        long offset = 0L;
        long low = 0L;
        long high = 0L;
        do {
            b = this.input.read();
            if (offset == 126L && ((b & 0x80L) > 0L || (b & 0x7FL) > 3L)) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decimal exceeds 128 bits");
            }
            if (offset < 63L) {
                low |= (b & 0x7FL) << (int)offset;
            } else if (offset == 63L) {
                low |= (b & 1L) << (int)offset;
                high |= (b & 0x7FL) >>> 1;
            } else {
                high |= (b & 0x7FL) << (int)(offset - 64L);
            }
            offset += 7L;
        } while ((b & 0x80L) > 0L);
        boolean negative = (low & 1L) == 1L;
        low >>>= 1;
        low |= (high & 1L) << 63;
        high >>>= 1;
        if (negative) {
            if (low == -1L) {
                low = 0L;
                ++high;
            } else {
                ++low;
            }
        }
        UnscaledDecimal128Arithmetic.pack((long)low, (long)high, (boolean)negative, (Slice)result);
    }

    public long nextLong() throws IOException {
        boolean isNegative;
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)this.input.read()) == -1L) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Reading BigInteger past EOF");
            }
            long work = 0x7FL & b;
            if (offset >= 63 && (offset != 63 || work > 1L)) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decimal does not fit long (invalid table schema?)");
            }
            result |= work << offset;
            offset += 7;
        } while (b >= 128L);
        boolean bl = isNegative = (result & 1L) != 0L;
        if (isNegative) {
            ++result;
            result = -result;
            result >>= 1;
            result |= Long.MIN_VALUE;
        } else {
            result >>= 1;
            result &= Long.MAX_VALUE;
        }
        return result;
    }

    public void nextShortDecimalVector(int items, BlockBuilder builder, DecimalType targetType, long[] sourceScale) throws IOException {
        for (int i = 0; i < items; ++i) {
            long value = this.nextLong();
            long rescaledDecimal = Decimals.rescale((long)value, (int)((int)sourceScale[i]), (int)targetType.getScale());
            targetType.writeLong(builder, rescaledDecimal);
        }
    }

    public void nextShortDecimalVector(int items, BlockBuilder builder, DecimalType targetType, long[] sourceScale, boolean[] isNull) throws IOException {
        for (int i = 0; i < items; ++i) {
            if (!isNull[i]) {
                long rescaledDecimal = Decimals.rescale((long)this.nextLong(), (int)((int)sourceScale[i]), (int)targetType.getScale());
                targetType.writeLong(builder, rescaledDecimal);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items-- > 0L) {
            int b;
            do {
                if ((b = this.input.read()) != -1) continue;
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Reading BigInteger past EOF");
            } while (b >= 128);
        }
    }
}

