/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.orc.checkpoint.DoubleStreamCheckpoint;
import io.prestosql.orc.stream.OrcInputStream;
import io.prestosql.orc.stream.ValueInputStream;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.io.IOException;

public class DoubleInputStream
implements ValueInputStream<DoubleStreamCheckpoint> {
    private static final int BUFFER_SIZE = 128;
    private final OrcInputStream input;
    private final byte[] buffer = new byte[1024];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public DoubleInputStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<DoubleStreamCheckpoint> getCheckpointType() {
        return DoubleStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(DoubleStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 8L;
        this.input.skipFully(length);
    }

    public double next() throws IOException {
        this.input.readFully(this.buffer, 0, 8);
        return this.slice.getDouble(0);
    }

    public Block nextBlock(Type type, boolean[] isNull) throws IOException {
        int items = isNull.length;
        BlockBuilder blockBuilder = type.createBlockBuilder(null, items);
        for (int batchBase = 0; batchBase < items; batchBase += 128) {
            int batchSize = Integer.min(items - batchBase, 128);
            int nonNullCount = 0;
            for (int i = batchBase; i < batchBase + batchSize; ++i) {
                if (isNull[i]) continue;
                ++nonNullCount;
            }
            this.input.readFully(this.buffer, 0, 8 * nonNullCount);
            int bufferIndex = 0;
            for (int i = batchBase; i < batchBase + batchSize; ++i) {
                if (!isNull[i]) {
                    type.writeDouble(blockBuilder, this.slice.getDouble(bufferIndex * 8));
                    ++bufferIndex;
                    continue;
                }
                blockBuilder.appendNull();
            }
        }
        return blockBuilder.build();
    }

    public Block nextBlock(Type type, int items) throws IOException {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, items);
        for (int batchBase = 0; batchBase < items; batchBase += 128) {
            int batchSize = Integer.min(items - batchBase, 128);
            this.input.readFully(this.buffer, 0, 8 * batchSize);
            for (int i = 0; i < batchSize; ++i) {
                type.writeDouble(blockBuilder, this.slice.getDouble(i * 8));
            }
        }
        return blockBuilder.build();
    }
}

