/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.orc.checkpoint.FloatStreamCheckpoint;
import io.prestosql.orc.stream.OrcInputStream;
import io.prestosql.orc.stream.ValueInputStream;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.io.IOException;

public class FloatInputStream
implements ValueInputStream<FloatStreamCheckpoint> {
    private static final int BUFFER_SIZE = 128;
    private final OrcInputStream input;
    private final byte[] buffer = new byte[512];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public FloatInputStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<FloatStreamCheckpoint> getCheckpointType() {
        return FloatStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(FloatStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 4L;
        this.input.skipFully(length);
    }

    public float next() throws IOException {
        this.input.readFully(this.buffer, 0, 4);
        return this.slice.getFloat(0);
    }

    public Block nextBlock(Type type, boolean[] isNull) throws IOException {
        int items = isNull.length;
        BlockBuilder blockBuilder = type.createBlockBuilder(null, items);
        for (int batchBase = 0; batchBase < items; batchBase += 128) {
            int batchSize = Integer.min(items - batchBase, 128);
            int nonNullCount = 0;
            for (int i = batchBase; i < batchBase + batchSize; ++i) {
                if (isNull[i]) continue;
                ++nonNullCount;
            }
            this.input.readFully(this.buffer, 0, 4 * nonNullCount);
            int bufferIndex = 0;
            for (int i = batchBase; i < batchBase + batchSize; ++i) {
                if (!isNull[i]) {
                    type.writeLong(blockBuilder, (long)Float.floatToIntBits(this.slice.getFloat(bufferIndex * 4)));
                    ++bufferIndex;
                    continue;
                }
                blockBuilder.appendNull();
            }
        }
        return blockBuilder.build();
    }

    public Block nextBlock(Type type, int items) throws IOException {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, items);
        for (int batchBase = 0; batchBase < items; batchBase += 128) {
            int batchSize = Integer.min(items - batchBase, 128);
            this.input.readFully(this.buffer, 0, 4 * batchSize);
            for (int i = 0; i < batchSize; ++i) {
                type.writeLong(blockBuilder, (long)Float.floatToIntBits(this.slice.getFloat(i * 4)));
            }
        }
        return blockBuilder.build();
    }
}

