/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.checkpoint.LongStreamCheckpoint;
import io.prestosql.orc.checkpoint.LongStreamV1Checkpoint;
import io.prestosql.orc.stream.LongDecode;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.OrcInputStream;
import java.io.IOException;

public class LongInputStreamV1
implements LongInputStream {
    private static final int MIN_REPEAT_SIZE = 3;
    private static final int MAX_LITERAL_SIZE = 128;
    private final OrcInputStream input;
    private final boolean signed;
    private final long[] literals = new long[128];
    private int numLiterals;
    private int delta;
    private int used;
    private boolean repeat;
    private long lastReadInputCheckpoint;

    public LongInputStreamV1(OrcInputStream input, boolean signed) {
        this.input = input;
        this.signed = signed;
        this.lastReadInputCheckpoint = input.getCheckpoint();
    }

    private void readValues() throws IOException {
        this.lastReadInputCheckpoint = this.input.getCheckpoint();
        int control = this.input.read();
        if (control == -1) {
            throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Read past end of RLE integer");
        }
        if (control < 128) {
            this.numLiterals = control + 3;
            this.used = 0;
            this.repeat = true;
            this.delta = this.input.read();
            if (this.delta == -1) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "End of stream in RLE Integer");
            }
            this.delta = (byte)this.delta;
            this.literals[0] = LongDecode.readVInt(this.signed, this.input);
        } else {
            this.numLiterals = 256 - control;
            this.used = 0;
            this.repeat = false;
            for (int i = 0; i < this.numLiterals; ++i) {
                this.literals[i] = LongDecode.readVInt(this.signed, this.input);
            }
        }
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.readValues();
        }
        long result = this.repeat ? this.literals[0] + (long)(this.used++ * this.delta) : this.literals[this.used++];
        return result;
    }

    @Override
    public Class<? extends LongStreamV1Checkpoint> getCheckpointType() {
        return LongStreamV1Checkpoint.class;
    }

    @Override
    public void seekToCheckpoint(LongStreamCheckpoint checkpoint) throws IOException {
        LongStreamV1Checkpoint v1Checkpoint = (LongStreamV1Checkpoint)checkpoint;
        if (this.lastReadInputCheckpoint == v1Checkpoint.getInputStreamCheckpoint() && v1Checkpoint.getOffset() <= this.numLiterals) {
            this.used = v1Checkpoint.getOffset();
        } else {
            this.input.seekToCheckpoint(v1Checkpoint.getInputStreamCheckpoint());
            this.numLiterals = 0;
            this.used = 0;
            this.skip(v1Checkpoint.getOffset());
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues();
            }
            long consume = Math.min(items, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            items -= consume;
        }
    }
}

