/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.prestosql.orc.StreamId;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.ByteArrayInputStream;
import io.prestosql.orc.stream.ByteInputStream;
import io.prestosql.orc.stream.DecimalInputStream;
import io.prestosql.orc.stream.DoubleInputStream;
import io.prestosql.orc.stream.FloatInputStream;
import io.prestosql.orc.stream.LongInputStreamV1;
import io.prestosql.orc.stream.LongInputStreamV2;
import io.prestosql.orc.stream.OrcInputStream;
import io.prestosql.orc.stream.ValueInputStream;

public final class ValueStreams {
    private ValueStreams() {
    }

    public static ValueInputStream<?> createValueStreams(StreamId streamId, OrcInputStream inputStream, OrcType.OrcTypeKind type, ColumnEncoding.ColumnEncodingKind encoding) {
        if (streamId.getStreamKind() == Stream.StreamKind.PRESENT) {
            return new BooleanInputStream(inputStream);
        }
        if (!(encoding != ColumnEncoding.ColumnEncodingKind.DICTIONARY && encoding != ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2 || streamId.getStreamKind() != Stream.StreamKind.LENGTH && streamId.getStreamKind() != Stream.StreamKind.DATA)) {
            return ValueStreams.createLongStream(inputStream, encoding, false);
        }
        if (streamId.getStreamKind() == Stream.StreamKind.DATA) {
            switch (type) {
                case BOOLEAN: {
                    return new BooleanInputStream(inputStream);
                }
                case BYTE: {
                    return new ByteInputStream(inputStream);
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: {
                    return ValueStreams.createLongStream(inputStream, encoding, true);
                }
                case FLOAT: {
                    return new FloatInputStream(inputStream);
                }
                case DOUBLE: {
                    return new DoubleInputStream(inputStream);
                }
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new ByteArrayInputStream(inputStream);
                }
                case TIMESTAMP: {
                    return ValueStreams.createLongStream(inputStream, encoding, true);
                }
                case DECIMAL: {
                    return new DecimalInputStream(inputStream);
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.LENGTH) {
            switch (type) {
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: 
                case MAP: 
                case LIST: {
                    return ValueStreams.createLongStream(inputStream, encoding, false);
                }
            }
        }
        if (type == OrcType.OrcTypeKind.TIMESTAMP && streamId.getStreamKind() == Stream.StreamKind.SECONDARY) {
            return ValueStreams.createLongStream(inputStream, encoding, false);
        }
        if (type == OrcType.OrcTypeKind.DECIMAL && streamId.getStreamKind() == Stream.StreamKind.SECONDARY) {
            return ValueStreams.createLongStream(inputStream, encoding, true);
        }
        if (streamId.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA) {
            switch (type) {
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new ByteArrayInputStream(inputStream);
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported column type %s for stream %s with encoding %s", new Object[]{type, streamId, encoding}));
    }

    private static ValueInputStream<?> createLongStream(OrcInputStream inputStream, ColumnEncoding.ColumnEncodingKind encoding, boolean signed) {
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            return new LongInputStreamV2(inputStream, signed, false);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            return new LongInputStreamV1(inputStream, signed);
        }
        throw new IllegalArgumentException("Unsupported encoding for long stream: " + (Object)((Object)encoding));
    }
}

