/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.plugin.hive.ConcurrentLazyQueue;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HivePartitionMetadata;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitLoader;
import io.prestosql.plugin.hive.HiveSplitSource;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.InternalHiveSplit;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.S3SelectPushdown;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.hive.util.HiveFileIterator;
import io.prestosql.plugin.hive.util.InternalHiveSplitFactory;
import io.prestosql.plugin.hive.util.ResumableTask;
import io.prestosql.plugin.hive.util.ResumableTasks;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final ListenableFuture<?> COMPLETED_FUTURE = Futures.immediateFuture(null);
    private final Table table;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final Optional<BucketSplitInfo> tableBucketInfo;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final int loaderConcurrency;
    private final boolean recursiveDirWalkerEnabled;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<Iterator<InternalHiveSplit>> fileIterators = new ConcurrentLinkedDeque<Iterator<InternalHiveSplit>>();
    private final ReentrantReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;

    public BackgroundHiveSplitLoader(Table table, Iterable<HivePartitionMetadata> partitions, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, Optional<BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int loaderConcurrency, boolean recursiveDirWalkerEnabled) {
        this.table = table;
        this.compactEffectivePredicate = compactEffectivePredicate;
        this.tableBucketInfo = tableBucketInfo;
        this.loaderConcurrency = loaderConcurrency;
        this.session = session;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.executor = executor;
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(partitions);
        this.hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.loaderConcurrency; ++i) {
            ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeNoMoreSplitsIfNecessary() {
        this.taskExecutionLock.readLock().lock();
        try {
            if (!this.partitions.isEmpty() || !this.fileIterators.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
            return;
        }
        finally {
            this.taskExecutionLock.readLock().unlock();
        }
        this.taskExecutionLock.writeLock().lock();
        try {
            if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                this.hiveSplitSource.noMoreSplits();
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
        }
        finally {
            this.taskExecutionLock.writeLock().unlock();
        }
    }

    private ListenableFuture<?> loadSplits() throws IOException {
        Iterator<InternalHiveSplit> splits = this.fileIterators.poll();
        if (splits == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            return this.loadPartition(partition);
        }
        while (splits.hasNext() && !this.stopped) {
            ListenableFuture<?> future = this.hiveSplitSource.addToQueue(splits.next());
            if (future.isDone()) continue;
            this.fileIterators.addFirst(splits);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> loadPartition(HivePartitionMetadata partition) throws IOException {
        String partitionName = partition.getHivePartition().getPartitionId();
        Properties schema = BackgroundHiveSplitLoader.getPartitionSchema(this.table, partition.getPartition());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        TupleDomain<? extends ColumnHandle> effectivePredicate = this.compactEffectivePredicate;
        Path path = new Path(MetastoreUtil.getPartitionLocation(this.table, partition.getPartition()));
        Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, false);
        FileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        boolean s3SelectPushdownEnabled = S3SelectPushdown.shouldEnablePushdownForTable(this.session, this.table, path.toString(), partition.getPartition());
        if (inputFormat instanceof SymlinkTextInputFormat) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
            }
            ListenableFuture<?> lastResult = COMPLETED_FUTURE;
            for (Path targetPath : BackgroundHiveSplitLoader.getTargetPathsFromSymlink(fs, path)) {
                TextInputFormat targetInputFormat = new TextInputFormat();
                FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, targetPath);
                JobConf targetJob = ConfigurationUtils.toJobConf(targetFilesystem.getConf());
                targetJob.setInputFormat(TextInputFormat.class);
                targetInputFormat.configure(targetJob);
                FileInputFormat.setInputPaths((JobConf)targetJob, (Path[])new Path[]{targetPath});
                InputSplit[] targetSplits = targetInputFormat.getSplits(targetJob, 0);
                InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(targetFilesystem, partitionName, inputFormat, schema, partitionKeys, effectivePredicate, partition.getColumnCoercions(), Optional.empty(), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled);
                lastResult = this.addSplitsToSource(targetSplits, splitFactory);
                if (!this.stopped) continue;
                return COMPLETED_FUTURE;
            }
            return lastResult;
        }
        Optional<HiveSplit.BucketConversion> bucketConversion = Optional.empty();
        boolean bucketConversionRequiresWorkerParticipation = false;
        if (partition.getPartition().isPresent()) {
            int partitionBucketCount;
            int readBucketCount;
            Optional<HiveBucketProperty> partitionBucketProperty = partition.getPartition().get().getStorage().getBucketProperty();
            if (this.tableBucketInfo.isPresent() && partitionBucketProperty.isPresent() && (readBucketCount = this.tableBucketInfo.get().getReadBucketCount()) != (partitionBucketCount = partitionBucketProperty.get().getBucketCount())) {
                bucketConversion = Optional.of(new HiveSplit.BucketConversion(readBucketCount, partitionBucketCount, this.tableBucketInfo.get().getBucketColumns()));
                if (readBucketCount > partitionBucketCount) {
                    bucketConversionRequiresWorkerParticipation = true;
                }
            }
        }
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(fs, partitionName, inputFormat, schema, partitionKeys, effectivePredicate, partition.getColumnCoercions(), bucketConversionRequiresWorkerParticipation ? bucketConversion : Optional.empty(), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled);
        if (BackgroundHiveSplitLoader.shouldUseFileSplitsFromInputFormat(inputFormat)) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Presto cannot read bucketed partition in an input format with UseFileSplitsFromInputFormat annotation: " + inputFormat.getClass().getSimpleName());
            }
            JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
            InputSplit[] splits = inputFormat.getSplits(jobConf, 0);
            return this.addSplitsToSource(splits, splitFactory);
        }
        if (this.tableBucketInfo.isPresent()) {
            return this.hiveSplitSource.addToQueue(this.getBucketedSplits(path, fs, splitFactory, this.tableBucketInfo.get(), bucketConversion));
        }
        boolean splittable = HiveUtil.getHeaderCount(schema) == 0 && HiveUtil.getFooterCount(schema) == 0 && !s3SelectPushdownEnabled;
        this.fileIterators.addLast(this.createInternalHiveSplitIterator(path, fs, splitFactory, splittable));
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> addSplitsToSource(InputSplit[] targetSplits, InternalHiveSplitFactory splitFactory) throws IOException {
        ListenableFuture<?> lastResult = COMPLETED_FUTURE;
        for (InputSplit inputSplit : targetSplits) {
            Optional<InternalHiveSplit> internalHiveSplit = splitFactory.createInternalHiveSplit((FileSplit)inputSplit);
            if (internalHiveSplit.isPresent()) {
                lastResult = this.hiveSplitSource.addToQueue(internalHiveSplit.get());
            }
            if (!this.stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private static boolean shouldUseFileSplitsFromInputFormat(InputFormat<?, ?> inputFormat) {
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseFileSplitsFromInputFormat"));
    }

    private Iterator<InternalHiveSplit> createInternalHiveSplitIterator(Path path, FileSystem fileSystem, InternalHiveSplitFactory splitFactory, boolean splittable) {
        return Streams.stream((Iterator)((Object)new HiveFileIterator(path, fileSystem, this.directoryLister, this.namenodeStats, this.recursiveDirWalkerEnabled ? HiveFileIterator.NestedDirectoryPolicy.RECURSE : HiveFileIterator.NestedDirectoryPolicy.IGNORED))).map(status -> splitFactory.createInternalHiveSplit((LocatedFileStatus)status, splittable)).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    private List<InternalHiveSplit> getBucketedSplits(Path path, FileSystem fileSystem, InternalHiveSplitFactory splitFactory, BucketSplitInfo bucketSplitInfo, Optional<HiveSplit.BucketConversion> bucketConversion) {
        int readBucketCount = bucketSplitInfo.getReadBucketCount();
        int tableBucketCount = bucketSplitInfo.getTableBucketCount();
        int partitionBucketCount = bucketConversion.isPresent() ? bucketConversion.get().getPartitionBucketCount() : tableBucketCount;
        ArrayList files = new ArrayList(partitionBucketCount);
        try {
            Iterators.addAll(files, (Iterator)((Object)new HiveFileIterator(path, fileSystem, this.directoryLister, this.namenodeStats, HiveFileIterator.NestedDirectoryPolicy.FAIL)));
        }
        catch (HiveFileIterator.NestedDirectoryNotAllowedException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. Found sub-directory in bucket directory for partition: %s", new SchemaTableName(this.table.getDatabaseName(), this.table.getTableName()), splitFactory.getPartitionName()));
        }
        if (files.size() != partitionBucketCount) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. The number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", new SchemaTableName(this.table.getDatabaseName(), this.table.getTableName()), files.size(), partitionBucketCount, splitFactory.getPartitionName()));
        }
        files.sort(null);
        ArrayList<InternalHiveSplit> splitList = new ArrayList<InternalHiveSplit>();
        for (int bucketNumber = 0; bucketNumber < Math.max(readBucketCount, partitionBucketCount); ++bucketNumber) {
            int partitionBucketNumber = bucketNumber % partitionBucketCount;
            int readBucketNumber = bucketNumber % readBucketCount;
            boolean containsEligibleTableBucket = false;
            boolean containsIneligibleTableBucket = false;
            for (int tableBucketNumber = bucketNumber % tableBucketCount; tableBucketNumber < tableBucketCount; tableBucketNumber += Math.max(readBucketCount, partitionBucketCount)) {
                if (bucketSplitInfo.isTableBucketEnabled(tableBucketNumber)) {
                    containsEligibleTableBucket = true;
                    continue;
                }
                containsIneligibleTableBucket = true;
            }
            if (containsEligibleTableBucket && containsIneligibleTableBucket) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The bucket filter cannot be satisfied. There are restrictions on the bucket filter when all the following is true: 1. a table has a different buckets count as at least one of its partitions that is read in this query; 2. the table has a different but compatible bucket number with another table in the query; 3. some buckets of the table is filtered out from the query, most likely using a filter on \"$bucket\". (table name: " + this.table.getTableName() + ", table bucket count: " + tableBucketCount + ", partition bucket count: " + partitionBucketCount + ", effective reading bucket count: " + readBucketCount + ")");
            }
            if (!containsEligibleTableBucket) continue;
            LocatedFileStatus file = (LocatedFileStatus)files.get(partitionBucketNumber);
            splitFactory.createInternalHiveSplit(file, readBucketNumber).ifPresent(splitList::add);
        }
        return splitList;
    }

    private static List<Path> getTargetPathsFromSymlink(FileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines((Readable)reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List<Column> keys = table.getPartitionColumns();
        List<String> values = partition.get().getValues();
        HiveUtil.checkCondition(keys.size() == values.size(), HiveErrorCode.HIVE_INVALID_METADATA, "Expected %s partition key values, but got %s", keys.size(), values.size());
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            HiveType hiveType = keys.get(i).getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = values.get(i);
            HiveUtil.checkCondition(value != null, HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "partition key value cannot be null for field: %s", name);
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return MetastoreUtil.getHiveSchema(table);
        }
        return MetastoreUtil.getHiveSchema(partition.get(), table);
    }

    public static class BucketSplitInfo {
        private final List<HiveColumnHandle> bucketColumns;
        private final int tableBucketCount;
        private final int readBucketCount;
        private final IntPredicate bucketFilter;

        public static Optional<BucketSplitInfo> createBucketSplitInfo(Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
            int readBucketCount;
            Objects.requireNonNull(bucketHandle, "bucketHandle is null");
            Objects.requireNonNull(bucketFilter, "buckets is null");
            if (!bucketHandle.isPresent()) {
                Preconditions.checkArgument((!bucketFilter.isPresent() ? 1 : 0) != 0, (Object)"bucketHandle must be present if bucketFilter is present");
                return Optional.empty();
            }
            int tableBucketCount = bucketHandle.get().getTableBucketCount();
            if (tableBucketCount != (readBucketCount = bucketHandle.get().getReadBucketCount()) && bucketFilter.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Filter on \"$bucket\" is not supported when the table has partitions with different bucket counts");
            }
            List<HiveColumnHandle> bucketColumns = bucketHandle.get().getColumns();
            IntPredicate predicate = bucketFilter.map(filter -> filter.getBucketsToKeep()::contains).orElse(bucket -> true);
            return Optional.of(new BucketSplitInfo(bucketColumns, tableBucketCount, readBucketCount, predicate));
        }

        private BucketSplitInfo(List<HiveColumnHandle> bucketColumns, int tableBucketCount, int readBucketCount, IntPredicate bucketFilter) {
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
            this.tableBucketCount = tableBucketCount;
            this.readBucketCount = readBucketCount;
            this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        }

        public List<HiveColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getReadBucketCount() {
            return this.readBucketCount;
        }

        public boolean isTableBucketEnabled(int tableBucketNumber) {
            return this.bucketFilter.test(tableBucketNumber);
        }
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResumableTask.TaskStatus process() {
            ListenableFuture future;
            do {
                if (BackgroundHiveSplitLoader.this.stopped) {
                    return ResumableTask.TaskStatus.finished();
                }
                BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                try {
                    future = BackgroundHiveSplitLoader.this.loadSplits();
                }
                catch (Exception e2) {
                    PrestoException e2;
                    if (e2 instanceof IOException) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e2);
                    } else if (!(e2 instanceof PrestoException)) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, (Throwable)e2);
                    }
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e2);
                    Preconditions.checkState((boolean)BackgroundHiveSplitLoader.this.stopped);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                finally {
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                }
                BackgroundHiveSplitLoader.this.invokeNoMoreSplitsIfNecessary();
            } while (future.isDone());
            return ResumableTask.TaskStatus.continueOn(future);
        }
    }
}

