/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveInsertTableHandle;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.MethodHandleUtil;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.procedure.Procedure;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.hive.common.FileUtils;

public class CreateEmptyPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle CREATE_EMPTY_PARTITION = MethodHandleUtil.methodHandle(CreateEmptyPartitionProcedure.class, (String)"createEmptyPartition", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, List.class, List.class});
    private final Supplier<TransactionalMetadata> hiveMetadataFactory;
    private final HiveMetastore metastore;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateJsonCodec;

    @Inject
    public CreateEmptyPartitionProcedure(Supplier<TransactionalMetadata> hiveMetadataFactory, HiveMetastore metastore, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateJsonCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
    }

    public Procedure get() {
        return new Procedure("system", "create_empty_partition", (List)ImmutableList.of((Object)new Procedure.Argument("schema_name", "varchar"), (Object)new Procedure.Argument("table_name", "varchar"), (Object)new Procedure.Argument("partition_columns", "array(varchar)"), (Object)new Procedure.Argument("partition_values", "array(varchar)")), CREATE_EMPTY_PARTITION.bindTo(this));
    }

    public void createEmptyPartition(ConnectorSession session, String schema, String table, List<Object> partitionColumnNames, List<Object> partitionValues) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doCreateEmptyPartition(session, schema, table, partitionColumnNames, partitionValues);
        }
    }

    private void doCreateEmptyPartition(ConnectorSession session, String schema, String table, List<Object> partitionColumnNames, List<Object> partitionValues) {
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.get();
        HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)hiveMetadata.beginInsert(session, new HiveTableHandle(schema, table));
        List actualPartitionColumnNames = (List)hiveInsertTableHandle.getInputColumns().stream().filter(HiveColumnHandle::isPartitionKey).map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (!Objects.equals(partitionColumnNames, actualPartitionColumnNames)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "input partition column names doesn't match actual partition column names");
        }
        List partitionStringValues = (List)partitionValues.stream().map(String.class::cast).collect(ImmutableList.toImmutableList());
        if (this.metastore.getPartition(schema, table, partitionStringValues).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Partition already exists");
        }
        String partitionName = FileUtils.makePartName((List)actualPartitionColumnNames, (List)partitionStringValues);
        LocationService.WriteInfo writeInfo = this.locationService.getPartitionWriteInfo(hiveInsertTableHandle.getLocationHandle(), Optional.empty(), partitionName);
        Slice serializedPartitionUpdate = Slices.wrappedBuffer((byte[])this.partitionUpdateJsonCodec.toJsonBytes((Object)new PartitionUpdate(partitionName, PartitionUpdate.UpdateMode.NEW, writeInfo.getWritePath(), writeInfo.getTargetPath(), (List<String>)ImmutableList.of(), 0L, 0L, 0L)));
        hiveMetadata.finishInsert(session, hiveInsertTableHandle, (Collection)ImmutableList.of((Object)serializedPartitionUpdate), (Collection)ImmutableList.of());
        hiveMetadata.commit();
    }
}

