/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class HiveAnalyzeProperties {
    public static final String PARTITIONS_PROPERTY = "partitions";
    private final List<PropertyMetadata<?>> analyzeProperties;

    @Inject
    public HiveAnalyzeProperties(TypeManager typeManager) {
        this.analyzeProperties = ImmutableList.of((Object)new PropertyMetadata(PARTITIONS_PROPERTY, "Partitions to be analyzed", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(array(varchar))")), List.class, null, false, HiveAnalyzeProperties::decodePartitionLists, value -> value));
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public static Optional<List<List<String>>> getPartitionList(Map<String, Object> properties) {
        List partitions = (List)properties.get(PARTITIONS_PROPERTY);
        return partitions == null ? Optional.empty() : Optional.of(partitions);
    }

    private static List<List<String>> decodePartitionLists(Object object) {
        if (object == null) {
            return null;
        }
        return ImmutableList.copyOf((Collection)((Collection)((Collection)object).stream().peek(HiveAnalyzeProperties::throwIfNull).map(partition -> (ImmutableList)((Collection)partition).stream().map(name -> (String)MoreObjects.firstNonNull((Object)((String)name), (Object)"__HIVE_DEFAULT_PARTITION__")).collect(ImmutableList.toImmutableList())).collect(ImmutableSet.toImmutableSet())));
    }

    private static void throwIfNull(Object object) {
        if (object == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Invalid null value in analyze partitions property");
        }
    }
}

