/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;

public class HiveBucketProperty {
    private final List<String> bucketedBy;
    private final int bucketCount;
    private final List<SortingColumn> sortedBy;

    @JsonCreator
    public HiveBucketProperty(@JsonProperty(value="bucketedBy") List<String> bucketedBy, @JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="sortedBy") List<SortingColumn> sortedBy) {
        this.bucketedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketedBy, "bucketedBy is null"));
        this.bucketCount = bucketCount;
        this.sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
    }

    public static Optional<HiveBucketProperty> fromStorageDescriptor(StorageDescriptor storageDescriptor, String tablePartitionName) {
        boolean numBucketsSet;
        boolean bucketColsSet = storageDescriptor.isSetBucketCols() && !storageDescriptor.getBucketCols().isEmpty();
        boolean bl = numBucketsSet = storageDescriptor.isSetNumBuckets() && storageDescriptor.getNumBuckets() > 0;
        if (!numBucketsSet) {
            return Optional.empty();
        }
        if (!bucketColsSet) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set: " + tablePartitionName);
        }
        Object sortedBy = ImmutableList.of();
        if (storageDescriptor.isSetSortCols()) {
            sortedBy = (List)storageDescriptor.getSortCols().stream().map(order -> SortingColumn.fromMetastoreApiOrder(order, tablePartitionName)).collect(ImmutableList.toImmutableList());
        }
        return Optional.of(new HiveBucketProperty(storageDescriptor.getBucketCols(), storageDescriptor.getNumBuckets(), (List<SortingColumn>)sortedBy));
    }

    @JsonProperty
    public List<String> getBucketedBy() {
        return this.bucketedBy;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<SortingColumn> getSortedBy() {
        return this.sortedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBucketProperty that = (HiveBucketProperty)o;
        return this.bucketCount == that.bucketCount && Objects.equals(this.bucketedBy, that.bucketedBy) && Objects.equals(this.sortedBy, that.sortedBy);
    }

    public int hashCode() {
        return Objects.hash(this.bucketedBy, this.bucketCount, this.sortedBy);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketedBy", this.bucketedBy).add("bucketCount", this.bucketCount).add("sortedBy", this.sortedBy).toString();
    }
}

