/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.orc.metadata.CompressionKind;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public enum HiveCompressionCodec {
    NONE(null, CompressionKind.NONE, CompressionCodecName.UNCOMPRESSED),
    SNAPPY(SnappyCodec.class, CompressionKind.SNAPPY, CompressionCodecName.SNAPPY),
    GZIP(GzipCodec.class, CompressionKind.ZLIB, CompressionCodecName.GZIP);

    private final Optional<Class<? extends CompressionCodec>> codec;
    private final CompressionKind orcCompressionKind;
    private final CompressionCodecName parquetCompressionCodec;

    private HiveCompressionCodec(Class<? extends CompressionCodec> codec, CompressionKind orcCompressionKind, CompressionCodecName parquetCompressionCodec) {
        this.codec = Optional.ofNullable(codec);
        this.orcCompressionKind = Objects.requireNonNull(orcCompressionKind, "orcCompressionKind is null");
        this.parquetCompressionCodec = Objects.requireNonNull(parquetCompressionCodec, "parquetCompressionCodec is null");
    }

    public Optional<Class<? extends CompressionCodec>> getCodec() {
        return this.codec;
    }

    public CompressionKind getOrcCompressionKind() {
        return this.orcCompressionKind;
    }

    public CompressionCodecName getParquetCompressionCodec() {
        return this.parquetCompressionCodec;
    }
}

