/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.ForHive;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.metastore.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.statistics.MetastoreHiveStatisticsProvider;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class HiveMetadataFactory
implements Supplier<TransactionalMetadata> {
    private static final Logger log = Logger.get(HiveMetadataFactory.class);
    private final boolean allowCorruptWritesForTesting;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final long perTransactionCacheMaximumSize;
    private final int maxPartitions;
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final BoundedExecutor renameExecution;
    private final TypeTranslator typeTranslator;
    private final String prestoVersion;

    @Inject
    public HiveMetadataFactory(HiveConfig hiveConfig, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, @ForHive ExecutorService executorService, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, TypeTranslator typeTranslator, NodeVersion nodeVersion) {
        this(metastore, hdfsEnvironment, partitionManager, hiveConfig.getDateTimeZone(), hiveConfig.getMaxConcurrentFileRenames(), hiveConfig.getAllowCorruptWritesForTesting(), hiveConfig.isSkipDeletionForAlter(), hiveConfig.isSkipTargetCleanupOnRollback(), hiveConfig.getWritesToNonManagedTablesEnabled(), hiveConfig.getCreatesOfNonManagedTablesEnabled(), hiveConfig.getPerTransactionMetastoreCacheMaximumSize(), hiveConfig.getMaxPartitionsPerScan(), typeManager, locationService, partitionUpdateCodec, executorService, typeTranslator, nodeVersion.toString());
    }

    public HiveMetadataFactory(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, int maxConcurrentFileRenames, boolean allowCorruptWritesForTesting, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, long perTransactionCacheMaximumSize, int maxPartitions, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, ExecutorService executorService, TypeTranslator typeTranslator, String prestoVersion) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.perTransactionCacheMaximumSize = perTransactionCacheMaximumSize;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.maxPartitions = maxPartitions;
        if (!allowCorruptWritesForTesting && !timeZone.equals((Object)DateTimeZone.getDefault())) {
            log.warn("Hive writes are disabled. To write data to Hive, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", new Object[]{timeZone.getID()});
        }
        this.renameExecution = new BoundedExecutor((Executor)executorService, maxConcurrentFileRenames);
    }

    @Override
    public HiveMetadata get() {
        SemiTransactionalHiveMetastore metastore = new SemiTransactionalHiveMetastore(this.hdfsEnvironment, CachingHiveMetastore.memoizeMetastore(this.metastore, this.perTransactionCacheMaximumSize), (Executor)this.renameExecution, this.skipDeletionForAlter, this.skipTargetCleanupOnRollback);
        return new HiveMetadata(metastore, this.hdfsEnvironment, this.partitionManager, this.timeZone, this.allowCorruptWritesForTesting, this.writesToNonManagedTablesEnabled, this.createsOfNonManagedTablesEnabled, this.typeManager, this.locationService, this.partitionUpdateCodec, this.typeTranslator, this.prestoVersion, new MetastoreHiveStatisticsProvider(metastore), this.maxPartitions);
    }
}

