/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class HivePartitioningHandle
implements ConnectorPartitioningHandle {
    private final int bucketCount;
    private final List<HiveType> hiveTypes;
    private final OptionalInt maxCompatibleBucketCount;

    @JsonCreator
    public HivePartitioningHandle(@JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="hiveTypes") List<HiveType> hiveTypes, @JsonProperty(value="maxCompatibleBucketCount") OptionalInt maxCompatibleBucketCount) {
        this.bucketCount = bucketCount;
        this.hiveTypes = Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        this.maxCompatibleBucketCount = maxCompatibleBucketCount;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<HiveType> getHiveTypes() {
        return this.hiveTypes;
    }

    @JsonProperty
    public OptionalInt getMaxCompatibleBucketCount() {
        return this.maxCompatibleBucketCount;
    }

    public String toString() {
        return String.format("buckets=%s, hiveTypes=%s", this.bucketCount, this.hiveTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePartitioningHandle that = (HivePartitioningHandle)o;
        return this.bucketCount == that.bucketCount && Objects.equals(this.hiveTypes, that.hiveTypes);
    }

    public int hashCode() {
        return Objects.hash(this.bucketCount, this.hiveTypes);
    }
}

