/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveConnectorFactory;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ConnectorFactory;
import java.util.Objects;
import java.util.Optional;

public class HivePlugin
implements Plugin {
    private final String name;
    private final Optional<HiveMetastore> metastore;

    public HivePlugin(String name) {
        this(name, Optional.empty());
    }

    public HivePlugin(String name, Optional<HiveMetastore> metastore) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new HiveConnectorFactory(this.name, HivePlugin.class.getClassLoader(), this.metastore));
    }
}

