/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveType;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class HiveTypeName {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HivePartitionKey.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize();
    private final String value;

    public HiveTypeName(String value) {
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public String toString() {
        return this.value;
    }

    public HiveType toHiveType() {
        return HiveType.valueOf(this.value);
    }

    public int getEstimatedSizeInBytes() {
        return INSTANCE_SIZE + this.value.length() * 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTypeName that = (HiveTypeName)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

