/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.spi.connector.NotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;

public class PartitionNotFoundException
extends NotFoundException {
    private final SchemaTableName tableName;
    private final List<String> partitionValues;

    public PartitionNotFoundException(SchemaTableName tableName, List<String> partitionValue) {
        this(tableName, partitionValue, String.format("Partition '%s' not found", tableName), null);
    }

    public PartitionNotFoundException(SchemaTableName tableName, List<String> partitionValues, String message) {
        this(tableName, partitionValues, message, null);
    }

    public PartitionNotFoundException(SchemaTableName tableName, List<String> partitionValue, Throwable cause) {
        this(tableName, partitionValue, String.format("Partition '%s' not found", tableName), cause);
    }

    public PartitionNotFoundException(SchemaTableName tableName, List<String> partitionValues, String message, Throwable cause) {
        super(message, cause);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partitionValues = Objects.requireNonNull(partitionValues, "partitionValue is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }
}

