/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.SchemaTableName;

public class TableAlreadyExistsException
extends PrestoException {
    private final SchemaTableName tableName;

    public TableAlreadyExistsException(SchemaTableName tableName) {
        this(tableName, String.format("Table already exists: '%s'", tableName));
    }

    public TableAlreadyExistsException(SchemaTableName tableName, String message) {
        this(tableName, message, null);
    }

    public TableAlreadyExistsException(SchemaTableName tableName, String message, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, message, cause);
        this.tableName = tableName;
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

