/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@EventType(value="WriteCompletedEvent")
@Immutable
public class WriteCompletedEvent {
    private final String queryId;
    private final String path;
    private final String schemaName;
    private final String tableName;
    private final String partitionName;
    private final String storageFormat;
    private final String writerImplementation;
    private final String prestoVersion;
    private final String host;
    private final String principal;
    private final String environment;
    private final Map<String, String> sessionProperties;
    private final Long bytes;
    private final long rows;
    private final Instant timestamp = Instant.now();

    public WriteCompletedEvent(String queryId, String path, String schemaName, String tableName, @Nullable String partitionName, String storageFormat, String writerImplementation, String prestoVersion, String serverAddress, @Nullable String principal, String environment, Map<String, String> sessionProperties, @Nullable Long bytes, long rows) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partitionName = partitionName;
        this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
        this.writerImplementation = Objects.requireNonNull(writerImplementation, "writerImplementation is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.host = Objects.requireNonNull(serverAddress, "serverAddress is null");
        this.principal = principal;
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.bytes = bytes;
        this.rows = rows;
    }

    @EventField
    public String getQueryId() {
        return this.queryId;
    }

    @EventField
    public String getPath() {
        return this.path;
    }

    @EventField
    public String getSchemaName() {
        return this.schemaName;
    }

    @EventField
    public String getTableName() {
        return this.tableName;
    }

    @Nullable
    @EventField
    public String getPartitionName() {
        return this.partitionName;
    }

    @EventField
    public String getStorageFormat() {
        return this.storageFormat;
    }

    @EventField
    public String getWriterImplementation() {
        return this.writerImplementation;
    }

    @EventField
    public String getPrestoVersion() {
        return this.prestoVersion;
    }

    @EventField(fieldMapping=EventField.EventFieldMapping.HOST)
    public String getHost() {
        return this.host;
    }

    @Nullable
    @EventField
    public String getPrincipal() {
        return this.principal;
    }

    @EventField
    public String getEnvironment() {
        return this.environment;
    }

    @EventField
    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    @Nullable
    @EventField
    public Long getBytes() {
        return this.bytes;
    }

    @EventField
    public long getRows() {
        return this.rows;
    }

    @EventField(fieldMapping=EventField.EventFieldMapping.TIMESTAMP)
    public Instant getTimestamp() {
        return this.timestamp;
    }
}

