/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.hive.ForHdfs;
import io.prestosql.plugin.hive.ForHiveMetastore;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.authentication.CachingKerberosHadoopAuthentication;
import io.prestosql.plugin.hive.authentication.DirectHdfsAuthentication;
import io.prestosql.plugin.hive.authentication.HadoopAuthentication;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.HdfsKerberosConfig;
import io.prestosql.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.prestosql.plugin.hive.authentication.ImpersonatingHdfsAuthentication;
import io.prestosql.plugin.hive.authentication.KerberosAuthentication;
import io.prestosql.plugin.hive.authentication.KerberosHadoopAuthentication;
import io.prestosql.plugin.hive.authentication.KerberosHiveMetastoreAuthentication;
import io.prestosql.plugin.hive.authentication.MetastoreKerberosConfig;
import io.prestosql.plugin.hive.authentication.NoHdfsAuthentication;
import io.prestosql.plugin.hive.authentication.NoHiveMetastoreAuthentication;
import io.prestosql.plugin.hive.authentication.SimpleHadoopAuthentication;
import javax.inject.Inject;

public final class AuthenticationModules {
    private AuthenticationModules() {
    }

    public static Module noHiveMetastoreAuthenticationModule() {
        return binder -> binder.bind(HiveMetastoreAuthentication.class).to(NoHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module kerberosHiveMetastoreAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HiveMetastoreAuthentication.class).to(KerberosHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHiveMetastore
            HadoopAuthentication createHadoopAuthentication(MetastoreKerberosConfig config, HdfsConfigurationInitializer updater) {
                String principal = config.getHiveMetastoreClientPrincipal();
                String keytabLocation = config.getHiveMetastoreClientKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    public static Module noHdfsAuthenticationModule() {
        return binder -> binder.bind(HdfsAuthentication.class).to(NoHdfsAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module simpleImpersonatingHdfsAuthenticationModule() {
        return binder -> {
            binder.bind(Key.get(HadoopAuthentication.class, ForHdfs.class)).to(SimpleHadoopAuthentication.class);
            binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
        };
    }

    public static Module kerberosHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(DirectHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationInitializer updater) {
                String principal = config.getHdfsPrestoPrincipal();
                String keytabLocation = config.getHdfsPrestoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    public static Module kerberosImpersonatingHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationInitializer updater) {
                String principal = config.getHdfsPrestoPrincipal();
                String keytabLocation = config.getHdfsPrestoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    private static HadoopAuthentication createCachingKerberosHadoopAuthentication(String principal, String keytabLocation, HdfsConfigurationInitializer updater) {
        KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(principal, keytabLocation);
        KerberosHadoopAuthentication kerberosHadoopAuthentication = KerberosHadoopAuthentication.createKerberosHadoopAuthentication(kerberosAuthentication, updater);
        return new CachingKerberosHadoopAuthentication(kerberosHadoopAuthentication);
    }
}

