/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import com.google.common.base.Preconditions;
import io.prestosql.plugin.hive.authentication.HadoopAuthentication;
import io.prestosql.plugin.hive.authentication.KerberosHadoopAuthentication;
import io.prestosql.plugin.hive.authentication.KerberosTicketUtils;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.UserGroupInformationShim;

public class CachingKerberosHadoopAuthentication
implements HadoopAuthentication {
    private final KerberosHadoopAuthentication delegate;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private UserGroupInformation userGroupInformation;
    @GuardedBy(value="lock")
    private long nextRefreshTime = Long.MIN_VALUE;

    public CachingKerberosHadoopAuthentication(KerberosHadoopAuthentication delegate) {
        this.delegate = Objects.requireNonNull(delegate, "hadoopAuthentication is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserGroupInformation getUserGroupInformation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refreshIsNeeded()) {
                this.refreshUgi();
            }
            return this.userGroupInformation;
        }
    }

    @GuardedBy(value="lock")
    private void refreshUgi() {
        this.userGroupInformation = this.delegate.getUserGroupInformation();
        this.nextRefreshTime = CachingKerberosHadoopAuthentication.calculateNextRefreshTime(this.userGroupInformation);
    }

    @GuardedBy(value="lock")
    private boolean refreshIsNeeded() {
        return this.nextRefreshTime < System.currentTimeMillis() || this.userGroupInformation == null;
    }

    private static long calculateNextRefreshTime(UserGroupInformation userGroupInformation) {
        Subject subject = UserGroupInformationShim.getSubject((UserGroupInformation)userGroupInformation);
        Preconditions.checkArgument((subject != null ? 1 : 0) != 0, (Object)"subject must be present in kerberos based UGI");
        KerberosTicket tgtTicket = KerberosTicketUtils.getTicketGrantingTicket(subject);
        return KerberosTicketUtils.getRefreshTime(tgtTicket);
    }
}

