/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.authentication.AuthenticationModules;
import java.util.function.Predicate;

public class HiveAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindAuthenticationModule(config -> config.getHiveMetastoreAuthenticationType() == HiveConfig.HiveMetastoreAuthenticationType.NONE, AuthenticationModules.noHiveMetastoreAuthenticationModule());
        this.bindAuthenticationModule(config -> config.getHiveMetastoreAuthenticationType() == HiveConfig.HiveMetastoreAuthenticationType.KERBEROS, AuthenticationModules.kerberosHiveMetastoreAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.noHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.simpleImpersonatingHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosImpersonatingHdfsAuthenticationModule());
    }

    private void bindAuthenticationModule(Predicate<HiveConfig> predicate, Module module) {
        this.install(ConditionalModule.installModuleIf(HiveConfig.class, predicate, (Module)module));
    }

    private static boolean noHdfsAuth(HiveConfig config) {
        return config.getHdfsAuthenticationType() == HiveConfig.HdfsAuthenticationType.NONE;
    }

    private static boolean kerberosHdfsAuth(HiveConfig config) {
        return config.getHdfsAuthenticationType() == HiveConfig.HdfsAuthenticationType.KERBEROS;
    }
}

