/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DateStatistics {
    private final Optional<LocalDate> min;
    private final Optional<LocalDate> max;

    @JsonCreator
    public DateStatistics(@JsonProperty(value="min") Optional<LocalDate> min, @JsonProperty(value="max") Optional<LocalDate> max) {
        this.min = Objects.requireNonNull(min, "min is null");
        this.max = Objects.requireNonNull(max, "max is null");
    }

    @JsonProperty
    public Optional<LocalDate> getMin() {
        return this.min;
    }

    @JsonProperty
    public Optional<LocalDate> getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateStatistics that = (DateStatistics)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", this.min).add("max", this.max).toString();
    }
}

