/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.base.Preconditions;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.metastore.Partition;
import java.util.Objects;

public class PartitionWithStatistics {
    private final Partition partition;
    private final String partitionName;
    private final PartitionStatistics statistics;

    public PartitionWithStatistics(Partition partition, String partitionName, PartitionStatistics statistics) {
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        Preconditions.checkArgument((boolean)HiveUtil.toPartitionValues(partitionName).equals(partition.getValues()), (String)"unexpected partition name: %s != %s", (Object)partitionName, partition.getValues());
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public PartitionStatistics getStatistics() {
        return this.statistics;
    }
}

