/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.spi.security.PrincipalType;
import java.util.Objects;

public class PermissionMetadata {
    private final HivePrivilegeInfo.HivePrivilege permission;
    private final boolean grantOption;

    @JsonCreator
    public PermissionMetadata(@JsonProperty(value="permission") HivePrivilegeInfo.HivePrivilege permission, @JsonProperty(value="grantOption") boolean grantOption) {
        this.permission = Objects.requireNonNull(permission, "permission is null");
        this.grantOption = grantOption;
    }

    public PermissionMetadata(HivePrivilegeInfo privilegeInfo) {
        this.permission = privilegeInfo.getHivePrivilege();
        this.grantOption = privilegeInfo.isGrantOption();
    }

    @JsonProperty
    public HivePrivilegeInfo.HivePrivilege getPermission() {
        return this.permission;
    }

    @JsonProperty
    public boolean isGrantOption() {
        return this.grantOption;
    }

    public HivePrivilegeInfo toHivePrivilegeInfo() {
        return new HivePrivilegeInfo(this.permission, this.grantOption, new HivePrincipal(PrincipalType.USER, "admin"), new HivePrincipal(PrincipalType.USER, "admin"));
    }
}

