/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.TableInput;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class GlueInputConverter {
    private GlueInputConverter() {
    }

    public static DatabaseInput convertDatabase(Database database) {
        DatabaseInput input = new DatabaseInput();
        input.setName(database.getDatabaseName());
        input.setParameters(database.getParameters());
        database.getComment().ifPresent(arg_0 -> ((DatabaseInput)input).setDescription(arg_0));
        database.getLocation().ifPresent(arg_0 -> ((DatabaseInput)input).setLocationUri(arg_0));
        return input;
    }

    public static TableInput convertTable(Table table) {
        TableInput input = new TableInput();
        input.setName(table.getTableName());
        input.setOwner(table.getOwner());
        input.setTableType(table.getTableType());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(table.getStorage(), table.getDataColumns()));
        input.setPartitionKeys((Collection)table.getPartitionColumns().stream().map(GlueInputConverter::convertColumn).collect(Collectors.toList()));
        input.setParameters(table.getParameters());
        table.getViewOriginalText().ifPresent(arg_0 -> ((TableInput)input).setViewOriginalText(arg_0));
        table.getViewExpandedText().ifPresent(arg_0 -> ((TableInput)input).setViewExpandedText(arg_0));
        return input;
    }

    public static PartitionInput convertPartition(PartitionWithStatistics partitionWithStatistics) {
        PartitionInput input = GlueInputConverter.convertPartition(partitionWithStatistics.getPartition());
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        if (!statistics.getColumnStatistics().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue metastore does not support column level statistics");
        }
        input.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(input.getParameters(), statistics.getBasicStatistics()));
        return input;
    }

    public static PartitionInput convertPartition(Partition partition) {
        PartitionInput input = new PartitionInput();
        input.setValues(partition.getValues());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(partition.getStorage(), partition.getColumns()));
        input.setParameters(partition.getParameters());
        return input;
    }

    private static StorageDescriptor convertStorage(Storage storage, List<Column> columns) {
        if (storage.isSkewed()) {
            throw new IllegalArgumentException("Writing to skewed table/partition is not supported");
        }
        SerDeInfo serdeInfo = new SerDeInfo().withSerializationLibrary(storage.getStorageFormat().getSerDeNullable()).withParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(storage.getLocation());
        sd.setColumns((Collection)columns.stream().map(GlueInputConverter::convertColumn).collect(Collectors.toList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setParameters((Map)ImmutableMap.of());
        if (storage.getBucketProperty().isPresent()) {
            sd.setNumberOfBuckets(Integer.valueOf(storage.getBucketProperty().get().getBucketCount()));
            sd.setBucketColumns(storage.getBucketProperty().get().getBucketedBy());
        }
        return sd;
    }

    private static com.amazonaws.services.glue.model.Column convertColumn(Column prestoColumn) {
        return new com.amazonaws.services.glue.model.Column().withName(prestoColumn.getName()).withType(prestoColumn.getType().toString()).withComment((String)prestoColumn.getComment().orElse(null));
    }
}

