/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.security.PrincipalType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class GlueToPrestoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";

    private GlueToPrestoConverter() {
    }

    public static Database convertDatabase(com.amazonaws.services.glue.model.Database glueDb) {
        return Database.builder().setDatabaseName(glueDb.getName()).setLocation(Optional.ofNullable(glueDb.getLocationUri())).setComment(Optional.ofNullable(glueDb.getDescription())).setParameters((Map)MoreObjects.firstNonNull((Object)glueDb.getParameters(), (Object)ImmutableMap.of())).setOwnerName(PUBLIC_OWNER).setOwnerType(PrincipalType.ROLE).build();
    }

    public static Table convertTable(com.amazonaws.services.glue.model.Table glueTable, String dbName) {
        Objects.requireNonNull(glueTable.getStorageDescriptor(), "Table StorageDescriptor is null");
        StorageDescriptor sd = glueTable.getStorageDescriptor();
        Table.Builder tableBuilder = Table.builder().setDatabaseName(dbName).setTableName(glueTable.getName()).setOwner(Strings.nullToEmpty((String)glueTable.getOwner())).setTableType(glueTable.getTableType()).setDataColumns(sd.getColumns().stream().map(GlueToPrestoConverter::convertColumn).collect(Collectors.toList())).setParameters((Map)MoreObjects.firstNonNull((Object)glueTable.getParameters(), (Object)ImmutableMap.of())).setViewOriginalText(Optional.ofNullable(glueTable.getViewOriginalText())).setViewExpandedText(Optional.ofNullable(glueTable.getViewExpandedText()));
        if (glueTable.getPartitionKeys() != null) {
            tableBuilder.setPartitionColumns(glueTable.getPartitionKeys().stream().map(GlueToPrestoConverter::convertColumn).collect(Collectors.toList()));
        } else {
            tableBuilder.setPartitionColumns(new ArrayList<Column>());
        }
        GlueToPrestoConverter.setStorageBuilder(sd, tableBuilder.getStorageBuilder());
        return tableBuilder.build();
    }

    private static void setStorageBuilder(StorageDescriptor sd, Storage.Builder storageBuilder) {
        Objects.requireNonNull(sd.getSerdeInfo(), "StorageDescriptor SerDeInfo is null");
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        Optional<HiveBucketProperty> bucketProperty = Optional.empty();
        if (sd.getNumberOfBuckets() > 0) {
            if (GlueToPrestoConverter.isNullOrEmpty(sd.getBucketColumns())) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set");
            }
            Object sortedBy = ImmutableList.of();
            if (!GlueToPrestoConverter.isNullOrEmpty(sd.getSortColumns())) {
                sortedBy = (List)sd.getSortColumns().stream().map(column -> new SortingColumn(column.getColumn(), SortingColumn.Order.fromMetastoreApiOrder(column.getSortOrder(), "unknown"))).collect(ImmutableList.toImmutableList());
            }
            bucketProperty = Optional.of(new HiveBucketProperty(sd.getBucketColumns(), sd.getNumberOfBuckets(), (List<SortingColumn>)sortedBy));
        }
        storageBuilder.setStorageFormat(StorageFormat.createNullable(serdeInfo.getSerializationLibrary(), sd.getInputFormat(), sd.getOutputFormat())).setLocation(Strings.nullToEmpty((String)sd.getLocation())).setBucketProperty(bucketProperty).setSkewed(sd.getSkewedInfo() != null && !GlueToPrestoConverter.isNullOrEmpty(sd.getSkewedInfo().getSkewedColumnNames())).setSerdeParameters((Map)MoreObjects.firstNonNull((Object)serdeInfo.getParameters(), (Object)ImmutableMap.of())).build();
    }

    private static Column convertColumn(com.amazonaws.services.glue.model.Column glueColumn) {
        return new Column(glueColumn.getName(), HiveType.valueOf(glueColumn.getType().toLowerCase(Locale.ENGLISH)), Optional.ofNullable(glueColumn.getComment()));
    }

    public static Partition convertPartition(com.amazonaws.services.glue.model.Partition gluePartition) {
        Objects.requireNonNull(gluePartition.getStorageDescriptor(), "Partition StorageDescriptor is null");
        StorageDescriptor sd = gluePartition.getStorageDescriptor();
        Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(gluePartition.getDatabaseName()).setTableName(gluePartition.getTableName()).setValues(gluePartition.getValues()).setColumns(sd.getColumns().stream().map(GlueToPrestoConverter::convertColumn).collect(Collectors.toList())).setParameters((Map)MoreObjects.firstNonNull((Object)gluePartition.getParameters(), (Object)ImmutableMap.of()));
        GlueToPrestoConverter.setStorageBuilder(sd, partitionBuilder.getStorageBuilder());
        return partitionBuilder.build();
    }

    private static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }
}

