/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.SelectObjectContentEvent;
import com.amazonaws.services.s3.model.SelectObjectContentEventVisitor;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.s3.PrestoS3ClientFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;

public class PrestoS3SelectClient
implements Closeable {
    private final AmazonS3 s3Client;
    private boolean requestComplete;
    private SelectObjectContentRequest selectObjectRequest;
    private SelectObjectContentResult selectObjectContentResult;

    public PrestoS3SelectClient(Configuration configuration, HiveConfig hiveConfig, PrestoS3ClientFactory s3ClientFactory) {
        Objects.requireNonNull(configuration, "configuration is null");
        Objects.requireNonNull(hiveConfig, "hiveConfig is null");
        Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
        this.s3Client = s3ClientFactory.getS3Client(configuration, hiveConfig);
    }

    public InputStream getRecordsContent(SelectObjectContentRequest selectObjectRequest) {
        this.selectObjectRequest = Objects.requireNonNull(selectObjectRequest, "selectObjectRequest is null");
        this.selectObjectContentResult = this.s3Client.selectObjectContent(selectObjectRequest);
        return this.selectObjectContentResult.getPayload().getRecordsInputStream(new SelectObjectContentEventVisitor(){

            public void visit(SelectObjectContentEvent.EndEvent endEvent) {
                PrestoS3SelectClient.this.requestComplete = true;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.selectObjectContentResult.close();
    }

    public String getKeyName() {
        return this.selectObjectRequest.getKey();
    }

    public String getBucketName() {
        return this.selectObjectRequest.getBucketName();
    }

    public boolean isRequestComplete() {
        return this.requestComplete;
    }
}

