/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import io.prestosql.plugin.hive.HiveCatalogName;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SqlStandardAccessControl
implements ConnectorAccessControl {
    public static final String ADMIN_ROLE_NAME = "admin";
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private static final SchemaTableName ROLES = new SchemaTableName("information_schema", "roles");
    private final String connectorId;
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;

    @Inject
    public SqlStandardAccessControl(HiveCatalogName connectorId, Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
    }

    public void checkCanCreateSchema(ConnectorTransactionHandle transaction, ConnectorIdentity identity, String schemaName) {
        if (!this.isAdmin(transaction, identity)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transaction, ConnectorIdentity identity, String schemaName) {
        if (!this.isDatabaseOwner(transaction, identity, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transaction, ConnectorIdentity identity, String schemaName, String newSchemaName) {
        if (!this.isDatabaseOwner(transaction, identity, schemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity) {
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        if (!this.isDatabaseOwner(transaction, identity, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        if (!this.isTableOwner(transaction, identity, tableName)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.isTableOwner(transaction, identity, tableName)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        if (!this.isTableOwner(transaction, identity, tableName)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        if (!this.isTableOwner(transaction, identity, tableName)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        if (!this.isTableOwner(transaction, identity, tableName)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, false)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.INSERT, false)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.DELETE, false)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName viewName) {
        if (!this.isDatabaseOwner(transaction, identity, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName viewName) {
        if (!this.isTableOwner(transaction, identity, viewName)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        this.checkCanSelectFromColumns(transaction, identity, tableName, columnNames);
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, true)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)identity);
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transaction, ConnectorIdentity identity, String propertyName) {
        if (!this.isAdmin(transaction, identity)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)this.connectorId, (String)propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        if (this.isTableOwner(transaction, identity, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(transaction, identity, privilege, tableName)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        if (this.isTableOwner(transaction, identity, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(transaction, identity, privilege, tableName)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanCreateRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role, Optional<PrestoPrincipal> grantor) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support WITH ADMIN statement");
        }
        if (!this.isAdmin(transactionHandle, identity)) {
            AccessDeniedException.denyCreateRole((String)role);
        }
    }

    public void checkCanDropRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role) {
        if (!this.isAdmin(transactionHandle, identity)) {
            AccessDeniedException.denyDropRole((String)role);
        }
    }

    public void checkCanGrantRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        if (!this.hasAdminOptionForRoles(transactionHandle, identity, roles)) {
            AccessDeniedException.denyGrantRoles(roles, grantees);
        }
    }

    public void checkCanRevokeRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        if (!this.hasAdminOptionForRoles(transactionHandle, identity, roles)) {
            AccessDeniedException.denyRevokeRoles(roles, grantees);
        }
    }

    public void checkCanSetRole(ConnectorTransactionHandle transaction, ConnectorIdentity identity, String role, String catalogName) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        if (!ThriftMetastoreUtil.isRoleApplicable(metastore, new HivePrincipal(PrincipalType.USER, identity.getUser()), role)) {
            AccessDeniedException.denySetRole((String)role);
        }
    }

    public void checkCanShowRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        if (!this.isAdmin(transactionHandle, identity)) {
            AccessDeniedException.denyShowRoles((String)catalogName);
        }
    }

    public void checkCanShowCurrentRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
    }

    private boolean isAdmin(ConnectorTransactionHandle transaction, ConnectorIdentity identity) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        return ThriftMetastoreUtil.isRoleEnabled(identity, metastore::listRoleGrants, ADMIN_ROLE_NAME);
    }

    private boolean isDatabaseOwner(ConnectorTransactionHandle transaction, ConnectorIdentity identity, String databaseName) {
        if ("default".equalsIgnoreCase(databaseName)) {
            return true;
        }
        if (this.isAdmin(transaction, identity)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        Optional<Database> databaseMetadata = metastore.getDatabase(databaseName);
        if (!databaseMetadata.isPresent()) {
            return false;
        }
        Database database = databaseMetadata.get();
        if (database.getOwnerType() == PrincipalType.USER && identity.getUser().equals(database.getOwnerName())) {
            return true;
        }
        if (database.getOwnerType() == PrincipalType.ROLE) {
            if (ThriftMetastoreUtil.isRoleEnabled(identity, metastore::listRoleGrants, database.getOwnerName())) {
                return true;
            }
        }
        return false;
    }

    private boolean isTableOwner(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName) {
        return this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP, false);
    }

    private boolean checkTablePermission(ConnectorTransactionHandle transaction, ConnectorIdentity identity, SchemaTableName tableName, HivePrivilegeInfo.HivePrivilege requiredPrivilege, boolean grantOptionRequired) {
        if (this.isAdmin(transaction, identity)) {
            return true;
        }
        if (tableName.equals((Object)ROLES)) {
            return false;
        }
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        return ThriftMetastoreUtil.listEnabledTablePrivileges(metastore, tableName.getSchemaName(), tableName.getTableName(), identity).filter(privilegeInfo -> !grantOptionRequired || privilegeInfo.isGrantOption()).anyMatch(privilegeInfo -> privilegeInfo.getHivePrivilege().equals((Object)requiredPrivilege));
    }

    private boolean hasGrantOptionForPrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName) {
        if (this.isAdmin(transaction, identity)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        return ThriftMetastoreUtil.listApplicableTablePrivileges(metastore, tableName.getSchemaName(), tableName.getTableName(), identity.getUser()).anyMatch(privilegeInfo -> privilegeInfo.getHivePrivilege().equals((Object)HivePrivilegeInfo.toHivePrivilege(privilege)) && privilegeInfo.isGrantOption());
    }

    private boolean hasAdminOptionForRoles(ConnectorTransactionHandle transaction, ConnectorIdentity identity, Set<String> roles) {
        if (this.isAdmin(transaction, identity)) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        Set rolesWithGrantOption = ThriftMetastoreUtil.listApplicableRoles(new HivePrincipal(PrincipalType.USER, identity.getUser()), metastore::listRoleGrants).filter(RoleGrant::isGrantable).map(RoleGrant::getRoleName).collect(Collectors.toSet());
        return rolesWithGrantOption.containsAll(roles);
    }
}

