/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;

public interface ResumableTask {
    public TaskStatus process();

    public static class TaskStatus {
        private final boolean finished;
        private final ListenableFuture<?> continuationFuture;

        private TaskStatus(boolean finished, ListenableFuture<?> continuationFuture) {
            this.finished = finished;
            this.continuationFuture = continuationFuture;
        }

        public static TaskStatus finished() {
            return new TaskStatus(true, Futures.immediateFuture(null));
        }

        public static TaskStatus continueOn(ListenableFuture<?> continuationFuture) {
            return new TaskStatus(false, continuationFuture);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public ListenableFuture<?> getContinuationFuture() {
            return this.continuationFuture;
        }
    }
}

