/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigBinder;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;

public class ConnectorObjectNameGeneratorModule
implements Module {
    private static final String CONNECTOR_PACKAGE_NAME = "io.prestosql.plugin.hive";
    private static final String DEFAULT_DOMAIN_BASE = "presto.plugin.hive";
    private final String catalogName;

    public ConnectorObjectNameGeneratorModule(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(ConnectorObjectNameGeneratorConfig.class);
    }

    @Provides
    ObjectNameGenerator createPrefixObjectNameGenerator(ConnectorObjectNameGeneratorConfig config) {
        String domainBase = (String)MoreObjects.firstNonNull((Object)config.getDomainBase(), (Object)DEFAULT_DOMAIN_BASE);
        return new ConnectorObjectNameGenerator(domainBase, this.catalogName);
    }

    public static final class ConnectorObjectNameGenerator
    implements ObjectNameGenerator {
        private final String domainBase;
        private final String catalogName;

        public ConnectorObjectNameGenerator(String domainBase, String catalogName) {
            this.domainBase = domainBase;
            this.catalogName = catalogName;
        }

        public String generatedNameOf(Class<?> type) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties((Map)ImmutableMap.builder().put((Object)"type", (Object)type.getSimpleName()).put((Object)"name", (Object)this.catalogName).build()).build();
        }

        public String generatedNameOf(Class<?> type, Map<String, String> properties) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties((Map)ImmutableMap.builder().putAll(properties).put((Object)"catalog", (Object)this.catalogName).build()).build();
        }

        private String toDomain(Class<?> type) {
            String domain = type.getPackage().getName();
            if (domain.startsWith(ConnectorObjectNameGeneratorModule.CONNECTOR_PACKAGE_NAME)) {
                domain = this.domainBase + domain.substring(ConnectorObjectNameGeneratorModule.CONNECTOR_PACKAGE_NAME.length());
            }
            return domain;
        }
    }

    public static class ConnectorObjectNameGeneratorConfig {
        private String domainBase;

        public String getDomainBase() {
            return this.domainBase;
        }

        @Config(value="jmx.base-name")
        public ConnectorObjectNameGeneratorConfig setDomainBase(String domainBase) {
            this.domainBase = domainBase;
            return this;
        }
    }
}

