/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<List<List<String>>> analyzePartitionValues;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="analyzePartitionValues") Optional<List<List<String>>> analyzePartitionValues) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.analyzePartitionValues = Objects.requireNonNull(analyzePartitionValues, "analyzePartitionValues is null");
    }

    public HiveTableHandle(String schemaName, String tableName) {
        this(schemaName, tableName, Optional.empty());
    }

    public HiveTableHandle withAnalyzePartitionValues(Optional<List<List<String>>> analyzePartitionValues) {
        return new HiveTableHandle(this.schemaName, this.tableName, analyzePartitionValues);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<List<List<String>>> getAnalyzePartitionValues() {
        return this.analyzePartitionValues;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableHandle that = (HiveTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.analyzePartitionValues, that.analyzePartitionValues);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.analyzePartitionValues);
    }

    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

