/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.util.Optional;
import javax.validation.constraints.Min;

public class GlueHiveMetastoreConfig {
    private Optional<String> glueRegion = Optional.empty();
    private boolean pinGlueClientToCurrentRegion;
    private int maxGlueConnections = 5;
    private Optional<String> defaultWarehouseDir = Optional.empty();
    private Optional<String> iamRole = Optional.empty();

    public Optional<String> getGlueRegion() {
        return this.glueRegion;
    }

    @Config(value="hive.metastore.glue.region")
    @ConfigDescription(value="AWS Region for Glue Data Catalog")
    public GlueHiveMetastoreConfig setGlueRegion(String region) {
        this.glueRegion = Optional.ofNullable(region);
        return this;
    }

    public boolean getPinGlueClientToCurrentRegion() {
        return this.pinGlueClientToCurrentRegion;
    }

    @Config(value="hive.metastore.glue.pin-client-to-current-region")
    @ConfigDescription(value="Should the Glue client be pinned to the current EC2 region")
    public GlueHiveMetastoreConfig setPinGlueClientToCurrentRegion(boolean pinGlueClientToCurrentRegion) {
        this.pinGlueClientToCurrentRegion = pinGlueClientToCurrentRegion;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxGlueConnections() {
        return this.maxGlueConnections;
    }

    @Config(value="hive.metastore.glue.max-connections")
    @ConfigDescription(value="Max number of concurrent connections to Glue")
    public GlueHiveMetastoreConfig setMaxGlueConnections(int maxGlueConnections) {
        this.maxGlueConnections = maxGlueConnections;
        return this;
    }

    public Optional<String> getDefaultWarehouseDir() {
        return this.defaultWarehouseDir;
    }

    @Config(value="hive.metastore.glue.default-warehouse-dir")
    @ConfigDescription(value="Hive Glue metastore default warehouse directory")
    public GlueHiveMetastoreConfig setDefaultWarehouseDir(String defaultWarehouseDir) {
        this.defaultWarehouseDir = Optional.ofNullable(defaultWarehouseDir);
        return this;
    }

    public Optional<String> getIamRole() {
        return this.iamRole;
    }

    @Config(value="hive.metastore.glue.iam-role")
    @ConfigDescription(value="ARN of an IAM role to assume when connecting to the Hive Glue metastore")
    public GlueHiveMetastoreConfig setIamRole(String iamRole) {
        this.iamRole = Optional.ofNullable(iamRole);
        return this;
    }
}

