/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.util.RetryDriver;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ThriftHiveMetastoreConfig {
    private int maxRetries = 9;
    private double backoffScaleFactor = 2.0;
    private Duration minBackoffDelay = RetryDriver.DEFAULT_SLEEP_TIME;
    private Duration maxBackoffDelay = RetryDriver.DEFAULT_SLEEP_TIME;
    private Duration maxRetryTime = RetryDriver.DEFAULT_MAX_RETRY_TIME;

    @Min(value=0L)
    public @Min(value=0L) int getMaxRetries() {
        return this.maxRetries;
    }

    @Config(value="hive.metastore.thrift.client.max-retries")
    @ConfigDescription(value="Maximum number of retry attempts for metastore requests")
    public ThriftHiveMetastoreConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public double getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    @Config(value="hive.metastore.thrift.client.backoff-scale-factor")
    @ConfigDescription(value="Scale factor for metastore request retry delay")
    public ThriftHiveMetastoreConfig setBackoffScaleFactor(double backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
        return this;
    }

    @NotNull
    public Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Config(value="hive.metastore.thrift.client.max-retry-time")
    @ConfigDescription(value="Total time limit for a metastore request to be retried")
    public ThriftHiveMetastoreConfig setMaxRetryTime(Duration maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
        return this;
    }

    public Duration getMinBackoffDelay() {
        return this.minBackoffDelay;
    }

    @Config(value="hive.metastore.thrift.client.min-backoff-delay")
    @ConfigDescription(value="Minimum delay between metastore request retries")
    public ThriftHiveMetastoreConfig setMinBackoffDelay(Duration minBackoffDelay) {
        this.minBackoffDelay = minBackoffDelay;
        return this;
    }

    public Duration getMaxBackoffDelay() {
        return this.maxBackoffDelay;
    }

    @Config(value="hive.metastore.thrift.client.max-backoff-delay")
    @ConfigDescription(value="Maximum delay between metastore request retries")
    public ThriftHiveMetastoreConfig setMaxBackoffDelay(Duration maxBackoffDelay) {
        this.maxBackoffDelay = maxBackoffDelay;
        return this;
    }
}

