/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.s3.HiveS3Config;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystemMetricCollector;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystemStats;
import java.net.URI;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;

public class PrestoS3ClientFactory {
    private static final String S3_ACCESS_KEY = "presto.s3.access-key";
    private static final String S3_SECRET_KEY = "presto.s3.secret-key";
    private static final String S3_CREDENTIALS_PROVIDER = "presto.s3.credentials-provider";
    private static final String S3_USE_INSTANCE_CREDENTIALS = "presto.s3.use-instance-credentials";
    private static final String S3_CONNECT_TIMEOUT = "presto.s3.connect-timeout";
    private static final String S3_SOCKET_TIMEOUT = "presto.s3.socket-timeout";
    private static final String S3_SSL_ENABLED = "presto.s3.ssl.enabled";
    private static final String S3_MAX_ERROR_RETRIES = "presto.s3.max-error-retries";
    private static final String S3_USER_AGENT_PREFIX = "presto.s3.user-agent-prefix";
    private static final String S3_SELECT_PUSHDOWN_MAX_CONNECTIONS = "hive.s3select-pushdown.max-connections";
    private static String s3UserAgentSuffix = "presto";
    @GuardedBy(value="this")
    private AmazonS3 s3Client;

    synchronized AmazonS3 getS3Client(Configuration config, HiveConfig hiveConfig) {
        Region region;
        if (this.s3Client != null) {
            return this.s3Client;
        }
        HiveS3Config defaults = new HiveS3Config();
        String userAgentPrefix = config.get(S3_USER_AGENT_PREFIX, defaults.getS3UserAgentPrefix());
        int maxErrorRetries = config.getInt(S3_MAX_ERROR_RETRIES, defaults.getS3MaxErrorRetries());
        boolean sslEnabled = config.getBoolean(S3_SSL_ENABLED, defaults.isS3SslEnabled());
        Duration connectTimeout = Duration.valueOf((String)config.get(S3_CONNECT_TIMEOUT, defaults.getS3ConnectTimeout().toString()));
        Duration socketTimeout = Duration.valueOf((String)config.get(S3_SOCKET_TIMEOUT, defaults.getS3SocketTimeout().toString()));
        int maxConnections = config.getInt(S3_SELECT_PUSHDOWN_MAX_CONNECTIONS, hiveConfig.getS3SelectPushdownMaxConnections());
        if (hiveConfig.isS3SelectPushdownEnabled()) {
            s3UserAgentSuffix = "presto-select";
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration().withMaxErrorRetry(maxErrorRetries).withProtocol(sslEnabled ? Protocol.HTTPS : Protocol.HTTP).withConnectionTimeout(Math.toIntExact(connectTimeout.toMillis())).withSocketTimeout(Math.toIntExact(socketTimeout.toMillis())).withMaxConnections(maxConnections).withUserAgentPrefix(userAgentPrefix).withUserAgentSuffix(s3UserAgentSuffix);
        PrestoS3FileSystemStats stats = new PrestoS3FileSystemStats();
        PrestoS3FileSystemMetricCollector metricCollector = new PrestoS3FileSystemMetricCollector(stats);
        AWSCredentialsProvider awsCredentialsProvider = this.getAwsCredentialsProvider(config, defaults);
        AmazonS3Builder clientBuilder = ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(awsCredentialsProvider)).withClientConfiguration(clientConfiguration)).withMetricsCollector((RequestMetricCollector)metricCollector)).enablePathStyleAccess();
        boolean regionOrEndpointSet = false;
        String endpoint = config.get("presto.s3.endpoint");
        boolean pinS3ClientToCurrentRegion = config.getBoolean("presto.s3.pin-client-to-current-region", defaults.isPinS3ClientToCurrentRegion());
        Verify.verify((!pinS3ClientToCurrentRegion || endpoint == null ? 1 : 0) != 0, (String)"Invalid configuration: either endpoint can be set or S3 client can be pinned to the current region", (Object[])new Object[0]);
        if (pinS3ClientToCurrentRegion && (region = Regions.getCurrentRegion()) != null) {
            clientBuilder.withRegion(region.getName());
            regionOrEndpointSet = true;
        }
        if (!Strings.isNullOrEmpty((String)endpoint)) {
            clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
            regionOrEndpointSet = true;
        }
        if (!regionOrEndpointSet) {
            clientBuilder.withRegion(Regions.US_EAST_1);
            clientBuilder.setForceGlobalBucketAccessEnabled(Boolean.valueOf(true));
        }
        this.s3Client = (AmazonS3)clientBuilder.build();
        return this.s3Client;
    }

    private AWSCredentialsProvider getAwsCredentialsProvider(Configuration conf, HiveS3Config defaults) {
        Optional<AWSCredentials> credentials = PrestoS3ClientFactory.getAwsCredentials(conf);
        if (credentials.isPresent()) {
            return new AWSStaticCredentialsProvider(credentials.get());
        }
        boolean useInstanceCredentials = conf.getBoolean(S3_USE_INSTANCE_CREDENTIALS, defaults.isS3UseInstanceCredentials());
        if (useInstanceCredentials) {
            return InstanceProfileCredentialsProvider.getInstance();
        }
        String providerClass = conf.get(S3_CREDENTIALS_PROVIDER);
        if (!Strings.isNullOrEmpty((String)providerClass)) {
            return PrestoS3ClientFactory.getCustomAWSCredentialsProvider(conf, providerClass);
        }
        throw new RuntimeException("S3 credentials not configured");
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(Configuration conf, String providerClass) {
        try {
            return conf.getClassByName(providerClass).asSubclass(AWSCredentialsProvider.class).getConstructor(URI.class, Configuration.class).newInstance(null, conf);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s", providerClass), e);
        }
    }

    private static Optional<AWSCredentials> getAwsCredentials(Configuration conf) {
        String accessKey = conf.get(S3_ACCESS_KEY);
        String secretKey = conf.get(S3_SECRET_KEY);
        if (Strings.isNullOrEmpty((String)accessKey) || Strings.isNullOrEmpty((String)secretKey)) {
            return Optional.empty();
        }
        return Optional.of(new BasicAWSCredentials(accessKey, secretKey));
    }
}

