/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.prestosql.plugin.base.security.FileBasedAccessControlModule;
import io.prestosql.plugin.base.security.ReadOnlySecurityModule;
import io.prestosql.plugin.hive.security.LegacySecurityModule;
import io.prestosql.plugin.hive.security.SecurityConfig;
import io.prestosql.plugin.hive.security.SqlStandardSecurityModule;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindSecurityModule("legacy", new LegacySecurityModule());
        this.bindSecurityModule("file", (Module)new FileBasedAccessControlModule());
        this.bindSecurityModule("read-only", (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule("sql-standard", new SqlStandardSecurityModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(SecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), (Module)module));
    }
}

