/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import io.prestosql.plugin.base.security.ForwardingConnectorAccessControl;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.ConnectorIdentity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SystemTableAwareAccessControl
extends ForwardingConnectorAccessControl {
    private final ConnectorAccessControl delegate;

    public SystemTableAwareAccessControl(ConnectorAccessControl delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    protected ConnectorAccessControl delegate() {
        return this.delegate;
    }

    public void checkCanShowColumnsMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        Optional<SchemaTableName> sourceTableName = HiveMetadata.getSourceTableNameFromSystemTable(tableName);
        if (sourceTableName.isPresent()) {
            try {
                this.checkCanShowColumnsMetadata(transactionHandle, identity, sourceTableName.get());
                return;
            }
            catch (AccessDeniedException e) {
                AccessDeniedException.denyShowColumnsMetadata((String)tableName.toString());
            }
        }
        this.delegate.checkCanShowColumnsMetadata(transactionHandle, identity, tableName);
    }

    public List<ColumnMetadata> filterColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, List<ColumnMetadata> columns) {
        Optional<SchemaTableName> sourceTableName = HiveMetadata.getSourceTableNameFromSystemTable(tableName);
        if (sourceTableName.isPresent()) {
            return this.filterColumns(transactionHandle, identity, sourceTableName.get(), columns);
        }
        return this.delegate.filterColumns(transactionHandle, identity, tableName, columns);
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        Optional<SchemaTableName> sourceTableName = HiveMetadata.getSourceTableNameFromSystemTable(tableName);
        if (sourceTableName.isPresent()) {
            try {
                this.checkCanSelectFromColumns(transactionHandle, identity, sourceTableName.get(), columnNames);
                return;
            }
            catch (AccessDeniedException e) {
                AccessDeniedException.denySelectTable((String)tableName.toString());
            }
        }
        this.delegate.checkCanSelectFromColumns(transactionHandle, identity, tableName, columnNames);
    }
}

