/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;

public final class ConfigurationUtils {
    private static final Configuration INITIAL_CONFIGURATION;

    private ConfigurationUtils() {
    }

    public static Configuration getInitialConfiguration() {
        return ConfigurationUtils.copy(INITIAL_CONFIGURATION);
    }

    public static Configuration copy(Configuration configuration) {
        Configuration copy = new Configuration(false);
        ConfigurationUtils.copy(configuration, copy);
        return copy;
    }

    public static void copy(Configuration from, Configuration to) {
        for (Map.Entry entry : from) {
            to.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static JobConf toJobConf(Configuration conf) {
        if (conf instanceof JobConf) {
            return (JobConf)conf;
        }
        return new JobConf(conf);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        INITIAL_CONFIGURATION = new Configuration(false);
        Configuration defaultConfiguration = new Configuration();
        ConfigurationUtils.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

