/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HiveQlTranslation {
    private static final Pattern LITERALS = Pattern.compile("(?s)((?<![\\\\])['\"])((?:.(?!(?<![\\\\])\\1))*.?)\\1");

    private HiveQlTranslation() {
    }

    public static String translateHiveQlToPrestoSql(String hiveSql) {
        Matcher matcher = LITERALS.matcher(hiveSql);
        StringBuilder prestoSql = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            prestoSql.append(HiveQlTranslation.replaceBackTicks(hiveSql.substring(start, matcher.start()))).append("'").append(HiveQlTranslation.removeHiveEscapes(HiveQlTranslation.escapeQuotes(matcher.group().substring(1, matcher.group().length() - 1)))).append("'");
            start = matcher.end();
        }
        prestoSql.append(HiveQlTranslation.replaceBackTicks(hiveSql.substring(start)));
        return prestoSql.toString();
    }

    private static String removeHiveEscapes(String value) {
        return value.replaceAll("(?s)\\\\(.)", "$1");
    }

    private static String escapeQuotes(String value) {
        return value.replace("'", "''");
    }

    private static String replaceBackTicks(String value) {
        return value.replace("`", "\"");
    }
}

