/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Strings;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;

public class PartitionOfflineException
extends PrestoException {
    private final SchemaTableName tableName;
    private final String partition;

    public PartitionOfflineException(SchemaTableName tableName, String partitionName, boolean forPresto, String offlineMessage) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_OFFLINE, PartitionOfflineException.formatMessage(tableName, partitionName, forPresto, offlineMessage));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partition = Objects.requireNonNull(partitionName, "partition is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public String getPartition() {
        return this.partition;
    }

    private static String formatMessage(SchemaTableName tableName, String partitionName, boolean forPresto, String offlineMessage) {
        StringBuilder resultBuilder = new StringBuilder().append("Table '").append(tableName).append("'").append(" partition '").append(partitionName).append("'").append(" is offline");
        if (forPresto) {
            resultBuilder.append(" for Presto");
        }
        if (!Strings.isNullOrEmpty((String)offlineMessage)) {
            resultBuilder.append(": ").append(offlineMessage);
        }
        return resultBuilder.toString();
    }
}

