/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class TableToPartitionMapping {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TableToPartitionMapping.class).instanceSize();
    private static final int INTEGER_INSTANCE_SIZE = ClassLayout.parseClass(Integer.class).instanceSize();
    private static final int OPTIONAL_INSTANCE_SIZE = ClassLayout.parseClass(Optional.class).instanceSize();
    private final Optional<Map<Integer, Integer>> tableToPartitionColumns;
    private final Map<Integer, HiveTypeName> partitionColumnCoercions;

    public static TableToPartitionMapping empty() {
        return new TableToPartitionMapping(Optional.empty(), (Map<Integer, HiveTypeName>)ImmutableMap.of());
    }

    public static TableToPartitionMapping mapColumnsByIndex(Map<Integer, HiveTypeName> columnCoercions) {
        return new TableToPartitionMapping(Optional.empty(), columnCoercions);
    }

    @JsonCreator
    public TableToPartitionMapping(@JsonProperty(value="tableToPartitionColumns") Optional<Map<Integer, Integer>> tableToPartitionColumns, @JsonProperty(value="partitionColumnCoercions") Map<Integer, HiveTypeName> partitionColumnCoercions) {
        this.tableToPartitionColumns = tableToPartitionColumns.map(TableToPartitionMapping::isIdentityMapping).orElse(true) != false ? Optional.empty() : Objects.requireNonNull(tableToPartitionColumns, "tableToPartitionColumns is null").map(ImmutableMap::copyOf);
        this.partitionColumnCoercions = ImmutableMap.copyOf(Objects.requireNonNull(partitionColumnCoercions, "partitionColumnCoercions is null"));
    }

    @VisibleForTesting
    static boolean isIdentityMapping(Map<Integer, Integer> map) {
        for (int i = 0; i < map.size(); ++i) {
            if (Objects.equals(map.get(i), i)) continue;
            return false;
        }
        return true;
    }

    @JsonProperty
    public Map<Integer, HiveTypeName> getPartitionColumnCoercions() {
        return this.partitionColumnCoercions;
    }

    @JsonProperty
    public Optional<Map<Integer, Integer>> getTableToPartitionColumns() {
        return this.tableToPartitionColumns;
    }

    public Optional<HiveType> getCoercion(int tableColumnIndex) {
        return this.getPartitionColumnIndex(tableColumnIndex).flatMap(partitionColumnIndex -> Optional.ofNullable(this.partitionColumnCoercions.get(partitionColumnIndex))).map(HiveTypeName::toHiveType);
    }

    private Optional<Integer> getPartitionColumnIndex(int tableColumnIndex) {
        if (!this.tableToPartitionColumns.isPresent()) {
            return Optional.of(tableColumnIndex);
        }
        return Optional.ofNullable(this.tableToPartitionColumns.get().get(tableColumnIndex));
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.partitionColumnCoercions.size()));
        for (HiveTypeName hiveTypeName : this.partitionColumnCoercions.values()) {
            result += INTEGER_INSTANCE_SIZE + hiveTypeName.getEstimatedSizeInBytes();
        }
        result += OPTIONAL_INSTANCE_SIZE;
        if (this.tableToPartitionColumns.isPresent()) {
            result = (int)((long)result + (SizeOf.sizeOfObjectArray((int)this.tableToPartitionColumns.get().size()) + (long)(2 * this.tableToPartitionColumns.get().size() * INTEGER_INSTANCE_SIZE)));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnCoercions", this.partitionColumnCoercions).add("tableToPartitionColumns", this.tableToPartitionColumns).toString();
    }
}

